
#ifndef IIRBASE_NATURE_DECLARATION_HH
#define IIRBASE_NATURE_DECLARATION_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
// NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S., and
// the terms of this license.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2, June
// 1991. A copy of this license agreement can be found in the file "LGPL",
// distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
//          Kathiresan Nellayappan
 
//---------------------------------------------------------------------------

#include "IIR_Declaration.hh"
#include "IRBasicDataTypes.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_NatureDefinition.hh"
#include "IIR_ArrayNatureDefinition.hh"

class IIR_TypeDefinition;
class IIRBase_NatureDeclaration : public IIR_Declaration {

public:
  IIR_Kind get_kind() const {return IIR_NATURE_DECLARATION;}
  IIR_Char *get_kind_text() const {return "IIR_NatureDeclaration";}

  /** Set the Nature of the terminal */
  void set_nature(IIR_NatureDefinition* nature);

  /** Get nature of the terminal */
  IIR_NatureDefinition *get_nature();

  IIR_AttributeSpecificationList attributes;

protected : 
  IIRBase_NatureDeclaration();
  virtual ~IIRBase_NatureDeclaration()= 0;

private:
  IIR_NatureDefinition* nature;

};
#endif
