
#ifndef IIRSCRAM_DESIGN_FILE_HH
#define IIRSCRAM_DESIGN_FILE_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//          Radharamanan Radhakrishnan

#include "IIRBase_DesignFile.hh"
#include "dl_list.hh"

/** The extension base of the node Design File node. */
class IIRScram_DesignFile : public IIRBase_DesignFile {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  /** Publishes the units in this file.  Also publishes a Makefile.  
     
      @param last_file_this_run True if this is the last file to published
      on this run of scram or not.  The last file is assumed to be the top
      level of the design. */
  void _publish_cc( bool last_file_this_run );

  /** Publishes a makefile for this design file.  Currently all
      Makefiles will be named "Makefile" and therefore successive code
      generator runs will overwrite this file.  Due to the
      implementation of the publishing code, multiple runs within one
      program execution will cause code to be appended to the Makefile.
      Therefore, to avoid duplicated rules, the parameter was
      introduced.
      
      @param top_level If this parameter is true, an "all" rule will be
      published, along with other rules that apply to all design files.
      If it's false, only code specific to this file will be published.

      In general, when publishing an IIR_DesignFileList, this method
      should be called with "false" until the last unit is being
      published. */
  void _publish_cc_makefile( bool top_level );
  void _publish_cc_library_data( published_file &_cc_out );
  
#ifdef PROCESS_COMBINATION
  IIR_ArchitectureDeclaration *_static_elaborate_design();
#endif
  const string _get_top_level_design_unit_name();

  // This is a temporary function, eventually will be chaned to _publish_cc_main
  void _publish_cc_main();

  /** Returns a handle to the work library that we were created with. */ 
  IIR_LibraryDeclaration *_get_work_library();

  /** Sets the file name to the string passed in. */
  void _set_file_name( const string &new_file_name );


  void _set_parser( scram *new_parser ){
    ASSERT( _my_parser == NULL );
    _my_parser = new_parser;
  }
  
  symbol_table *_get_symbol_table();

protected:
  IIRScram_DesignFile(){ 
    _my_parser = NULL;
  }

  virtual ~IIRScram_DesignFile() = 0;
    
private:
  scram *_my_parser;
};
#endif
