
#ifndef IIRSCRAM_FLOATING_POINT_LITERAL_HH
#define IIRSCRAM_FLOATING_POINT_LITERAL_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani 
//          Malolan Chetlur    

#include "IIRBase_FloatingPointLiteral.hh"

template <class type> class set;
class IIR_TypeDefinition;

class IIRScram_FloatingPointLiteral : public IIRBase_FloatingPointLiteral {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_value( published_file &_cc_out );
  void _publish_cc_universal_value( published_file &_cc_out );
  void _publish_cc_initialization_value( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_ams_function(published_file &);

  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0);

  ostream &_print( ostream & );
  IIR_Boolean _is_floating_literal() { return TRUE; }
  IIR_Boolean _is_negative();
  const string print(IIR_Int32);
  IIR_FP64 _get_value();
  IIR *_clone() { return this; }
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);

protected:
  IIRScram_FloatingPointLiteral() {}
  virtual ~IIRScram_FloatingPointLiteral() = 0;
    
private:
  IIR_Int32 _stmt_node_index;
};
#endif
