// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_ImageAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "StandardPackage.hh"

IIRScram_ImageAttribute::~IIRScram_ImageAttribute() {}


void 
IIRScram_ImageAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL && get_suffix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'IMAGE ";
  _vhdl_out << "(";
  get_suffix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") ";
}

void 
IIRScram_ImageAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_type_attribute( _cc_out, "IMAGE", TRUE );
}

IIR_TextLiteral *
IIRScram_ImageAttribute::_build_attribute_name() {
  char *name = "image";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_ImageAttribute::get_subtype(){
  return StandardPackage::get_string_type();
}

IIR_Declaration *
IIRScram_ImageAttribute::_get_implicit_declaration( const string &function_name,
						    IIR_TypeDefinition *return_type ){
  return _build_function_declaration( function_name, return_type );
}

void 
IIRScram_ImageAttribute::_resolve_suffix_special(){
  _resolve_suffix_base_type_of_prefix();
}


visitor_return_type *IIRScram_ImageAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ImageAttribute(this, arg);
};
