
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Narayanan Thondugulam
//          Timothy J. McBrayer

#include "IIR_LibraryUnit.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_LibraryDeclaration.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"
#include "language_processing_control.hh"

extern language_processing_control *lang_proc;

IIRScram_LibraryUnit::~IIRScram_LibraryUnit() {}

void
IIRScram_LibraryUnit::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _report_undefined_scram_fn("_publish_vhdl_binding_name");
}

void
IIRScram_LibraryUnit::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _report_undefined_scram_fn("_publish_vhdl_with_library_name");
}

IIR_EntityDeclaration* 
IIRScram_LibraryUnit::_get_entity() {
  _report_undefined_scram_fn("_get_entity()");
  return NULL;
}

void
IIRScram_LibraryUnit::_clone(IIR *cl) {
  IIR_LibraryUnit *clone = (IIR_LibraryUnit*)cl;
  IIRScram_Declaration::_clone(clone);
  IIR_Declaration *decl = context_items.first();
  
  while (decl != NULL) {
    clone->context_items.append(decl);
    decl = context_items.successor(decl);
  }
  clone->context_items = context_items;
  IIR_AttributeSpecification *attrib = attributes.first();
  while (attrib != NULL) {
    clone->attributes.append((IIR_AttributeSpecification*)attrib->_clone());
    attrib = attributes.successor(attrib);
  }
}

IIR_Boolean 
IIRScram_LibraryUnit::_is_homograph_of( IIR_Declaration *to_check ){
  ASSERT( to_check != NULL );
  if( to_check->_is_iir_library_unit() == TRUE ){

    // Two library units with the same name aren't homographs.
    return FALSE;    
  }
  else{
    return TRUE;
  }
}

IIR_LibraryDeclaration *
IIRScram_LibraryUnit::_get_library(){
  ASSERT( _get_declarative_region() != NULL );
  ASSERT( _get_declarative_region()->get_kind() == IIR_LIBRARY_DECLARATION );
  return (IIR_LibraryDeclaration *)_get_declarative_region();
}

const string
IIRScram_LibraryUnit::_get_library_directory(){
  ASSERT( _get_library() != NULL );
  return _get_library()->_get_path_to_directory();
}

void 
IIRScram_LibraryUnit::_publish_cc_include( published_file &_cc_out,
					   const char *const to_insert ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_LibraryUnit::_publish_cc_include" );
  ostringstream file_name_stream;
  _publish_cc_binding_name( file_name_stream );
  string binding_name = file_name_stream.str();
  if( binding_name != "" ){
    if( binding_name == "std_textioPkg" ){
      // Needed due to how stuff lays out after "make install"
      binding_name = "tyvis/std_textioPkg";
    }
    string suffix;
    if( to_insert != 0 ){
      suffix = to_insert;
    }
    suffix += ".hh";
    IIRScram::_publish_cc_include( _cc_out, binding_name + suffix );
  }
}

void 
IIRScram_LibraryUnit::_publish_cc_include( published_file &_cc_out ){
  _publish_cc_include( _cc_out, 0 );
  _publish_cc_include_decls( _cc_out );
  _publish_cc_include_elab( _cc_out );
}

void 
IIRScram_LibraryUnit::_publish_cc_include_decls( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_LibraryUnit::_publish_cc_include_decls" );
  ostringstream filename;
  _publish_cc_include_decls_prefix( filename );
  filename << ".hh";
  IIRScram::_publish_cc_include( _cc_out, filename.str() );
}

void 
IIRScram_LibraryUnit::_publish_cc_include_elab( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_LibraryUnit::_publish_cc_include_elab" );
  const string filename = _get_cc_elaboration_class_name() + ".hh";
  IIRScram::_publish_cc_include( _cc_out, filename );
}

void 
IIRScram_LibraryUnit::_publish_cc_elaborate(){
  _report_undefined_scram_fn("_publish_cc_elaborate()");
}
