
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
  
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
//          Kathiresan Nellayappan
 
#include "IIRScram_NatureDeclaration.hh"
#include "IIR_Identifier.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "IIR_TerminalDeclaration.hh"
#include "IIR_NatureDefinition.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "IIR_ArrayNatureDefinition.hh"

#include <iostream>
using std::cout;
using std::endl;

IIRScram_NatureDeclaration::IIRScram_NatureDeclaration() {}

IIRScram_NatureDeclaration::~IIRScram_NatureDeclaration() {}

void
IIRScram_NatureDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_Kind nature_kind;
  nature_kind=get_nature()->get_kind();
  
  ASSERT( nature_kind == IIR_SCALAR_NATURE_DEFINITION || nature_kind == IIR_ARRAY_SUBNATURE_DEFINITION );
  _vhdl_out << " nature " ;
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is " ;
  if( nature_kind == IIR_ARRAY_SUBNATURE_DEFINITION ){
    get_nature()->_publish_vhdl_type_decl(_vhdl_out);
  }
  else {
    get_nature()->_publish_vhdl_decl(_vhdl_out);
  }
  _vhdl_out << " ;\n";
}

IIRScram_Declaration::declaration_type 
IIRScram_NatureDeclaration::_get_type(){
  return NATURE;
}

IIR_TypeDefinition *
IIRScram_NatureDeclaration::_get_rval(){
  return get_nature();
}

void
IIRScram_NatureDeclaration::_publish_cc_lvalue(published_file &_cc_out) {
  _get_declarator()->_publish_cc_lvalue((ostream &)_cc_out);
}

void 
IIRScram_NatureDeclaration::_set_reference_terminal(IIR_TerminalDeclaration* ref_term) {
  reference_terminal = ref_term;
}

IIR_TerminalDeclaration*
IIRScram_NatureDeclaration::_get_reference_terminal() {
  return reference_terminal;
}

IIR_Boolean
IIRScram_NatureDeclaration::_is_array_type() {
  if( get_nature() != NULL ){
    return get_nature()->_is_array_type();
  }
  else {
    return FALSE;
  }
}

IIR_Int32
IIRScram_NatureDeclaration::_get_num_indexes(){
  if( get_nature() != NULL ){
    return get_nature()->_get_num_indexes();
  }
  else {
    return -1;
  }
}

IIR_TypeDefinition*
IIRScram_NatureDeclaration::_get_final_subtype(){
  ASSERT( get_nature() != NULL );

  return get_nature()->_get_final_subtype();
}

void
IIRScram_NatureDeclaration::_type_check() {
  IIR_NatureDefinition *nature_definition = get_nature();
  ASSERT(nature_definition != NULL);
  
  switch( nature_definition->get_kind() ){
  case IIR_SCALAR_NATURE_DEFINITION : {
    IIR_TerminalDeclaration *ref_terminal = nature_definition->get_reference_terminal();
    ref_terminal->set_subtype(nature_definition);
    ref_terminal->set_nature(nature_definition);
    _set_reference_terminal( ref_terminal );
    copy_location(this,ref_terminal);
    ref_terminal->_add_declaration();
    break;
  }
  case IIR_ARRAY_SUBNATURE_DEFINITION : {
    IIR_NatureDefinition *nature_def;
    nature_definition = (IIR_ArrayNatureDefinition *)_get_final_subtype();
    nature_def = nature_definition;
    ASSERT(nature_def != NULL) ;
    IIR_TerminalDeclaration *ref_terminal = nature_def->get_reference_terminal();
    ref_terminal->set_subtype(nature_def);
    ref_terminal->set_nature(nature_def);
    _set_reference_terminal( ref_terminal );
    copy_location(this,ref_terminal);
    break;
  }
  default :
    cout << "ERROR: Unknown nature definition \n"; 
    abort();
  }
}

IIR_TypeDefinition *
IIRScram_NatureDeclaration::get_subtype(){
  return get_nature();
}

void
IIRScram_NatureDeclaration::_publish_cc_type_info( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_NatureDeclaration::_publish_cc_type_info" );
  get_nature()->_publish_cc_type_info( _cc_out );
}
