/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DATASET_H__
#define __SG_DATASET_H__

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_worksheet.h"

#define SG_DATASET(obj)        GTK_CHECK_CAST (obj, sg_dataset_get_type (), SGdataset)
#define GTK_TYPE_SG_DATASET   (sg_dataset_get_type ())

#define SG_DATASET_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_dataset_get_type(), SGdatasetClass)
#define GTK_IS_SG_DATASET(obj)     GTK_CHECK_TYPE (obj, sg_dataset_get_type ())


typedef enum {
	SG_DATA_PYTHON,
	SG_DATA_FUNCTION,
	SG_DATA_COLUMNS,
	SG_DATA_MATRIX,
	SG_DATA_POINTS,
} SGdataType;

typedef enum {
	SG_STYLE_LPOINTS,  /* Regular XY dataset    */
	SG_STYLE_VBARS,    /* Vertical GtkPlotBar   */
	SG_STYLE_HBARS,    /* Horizontal GtkPlotBar */
	SG_STYLE_VBOXES,   /* Vertical GtkPlotBox   */
	SG_STYLE_HBOXES,   /* Horizontal GtkPlotBox */
	SG_STYLE_BUBBLES,  /* GtkPlotBubble         */
	SG_STYLE_FLUX,     /* GtkPlotFlux           */
	SG_STYLE_COLORS,   /* colored symbols       */
	SG_STYLE_DMAP,     /* GtkPlotDMap           */
	SG_STYLE_CONTOUR,  /* GtkPlotCSurface?      */
	SG_STYLE_CSURFACE, /* GtkPlotCSurface       */
	SG_STYLE_SURFACE,  /* GtkPlotSurface        */
} SGdataStyle;

#define  SG_STYLE_LPOINTS_MASK  GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_DX | \
                                GTK_PLOT_DATA_DY | \
                                GTK_PLOT_DATA_LABELS
#define  SG_STYLE_VBARS_MASK    GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y
#define  SG_STYLE_HBARS_MASK    GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y
#define  SG_STYLE_VBOXES_MASK   GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_Z | \
                                GTK_PLOT_DATA_DZ
#define  SG_STYLE_HBOXES_MASK   GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_Z | \
                                GTK_PLOT_DATA_DZ
#define  SG_STYLE_BUBBLES_MASK  GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_A
#define  SG_STYLE_FLUX_MASK     GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_DX | \
                                GTK_PLOT_DATA_DY | \
                                GTK_PLOT_DATA_DA
#define  SG_STYLE_COLORS_MASK   GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_A | \
                                GTK_PLOT_DATA_DA
#define  SG_STYLE_CONTOUR_MASK  GTK_PLOT_DATA_X | \
                                GTK_PLOT_DATA_Y | \
                                GTK_PLOT_DATA_Z


typedef struct _SGdataset SGdataset;
typedef struct _SGdatasetClass SGdatasetClass;


struct _SGdataset 
{
  GtkObject object;

  gint id;

  SGworksheet *worksheet;
  gint x;
  gint y;
  gint z;
  gint a;
  gint dx;
  gint dy;
  gint dz;
  gint da;
  gint l;

  GtkPlotData *real_data;

  SGdataType type;
  SGdataStyle style;

  gchar *exp;

  gchar *p_exp[9];

  gint ref_count;
};

struct _SGdatasetClass 
{
  GtkObjectClass parent_class;
};

GtkType		sg_dataset_get_type		(void);
SGdataset*	sg_dataset_new			(SGdataStyle style); 
SGdataset*      sg_dataset_new_function         (gchar *exp);
SGdataset*      sg_dataset_new_python           (SGdataStyle style,
						 gchar *p_exp[9]);
SGdataset*	sg_dataset_clone		(SGdataset *dataset);
void		sg_dataset_set_worksheet	(SGdataset *dataset,
						 SGworksheet *worksheet, 
				 	 	 gint col_x,
					 	 gint col_y,
					 	 gint col_z,
					 	 gint col_a,
					 	 gint col_ex,
					 	 gint col_ey,
					 	 gint col_ez,
					 	 gint col_ea,
					 	 gint col_l);
void		sg_dataset_set_matrix		(SGdataset *dataset,
						 SGworksheet *matrix); 
void		sg_dataset_add_point		(SGdataset *dataset,
						 gdouble *x,
						 gdouble *y,
						 gdouble *z,
						 gdouble *a,
						 gdouble *ex,
						 gdouble *ey,
						 gdouble *ez,
						 gdouble *ea,
						 gchar *label); 
void		sg_dataset_refresh		(SGdataset *dataset); 
void		sg_dataset_free_points		(SGdataset *dataset); 
void		sg_dataset_set_name		(SGdataset *dataset,
						 gchar *name); 
void            sg_dataset_set_exp              (SGdataset *dataset,
                                                 gchar *exp);
void            sg_dataset_set_python           (SGdataset *dataset,
                                                 gchar *p_exp[9]);

#endif /* __SG_DATASET_H__ */

