/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_matrix_menu.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "sg_clipboard.h"
#include "sg_matrix_convert.h"

static gpointer sg_menu_append_rows			(SGplugin *plugin); 
static gpointer sg_menu_append_cols			(SGplugin *plugin); 
static gpointer sg_menu_insert_rows			(SGplugin *plugin); 
static gpointer sg_menu_insert_cols			(SGplugin *plugin); 
static gpointer sg_menu_remove_rows			(SGplugin *plugin); 
static gpointer sg_menu_remove_cols			(SGplugin *plugin); 
static gpointer sg_menu_begin				(SGplugin *plugin); 
static gpointer sg_menu_end				(SGplugin *plugin); 
static gpointer sg_menu_reset				(SGplugin *plugin); 
static gpointer sg_menu_cut				(SGplugin *plugin); 
static gpointer sg_menu_copy				(SGplugin *plugin); 
static gpointer sg_menu_paste				(SGplugin *plugin); 
static gpointer sg_menu_clear				(SGplugin *plugin); 
static gpointer sg_menu_clear_all			(SGplugin *plugin); 
static gpointer sg_menu_properties			(SGplugin *plugin); 
static gpointer sg_menu_set_values			(SGplugin *plugin); 
static gpointer sg_menu_set_mvalues			(SGplugin *plugin); 
static gpointer sg_menu_set_range			(SGplugin *plugin); 
static gpointer sg_menu_transpose			(SGplugin *plugin); 
static gpointer sg_menu_mask				(SGplugin *plugin); 
static gpointer sg_menu_export				(SGplugin *plugin); 
static gpointer sg_menu_import				(SGplugin *plugin); 
static gpointer sg_menu_ascii				(SGplugin *plugin); 
static gpointer sg_menu_convert				(SGplugin *plugin); 


void
sg_matrix_menu_show(GtkWidget *widget, GdkEventButton *event)
{
  GList *w;
  SGworksheet *worksheet = NULL;
  GtkWidget *data;
  GdkModifierType mods;

  w = worksheets;
  while(w){
    worksheet = (SGworksheet *)w->data;
    data = worksheet->sheet;
    if(data && data == widget) break;
    w = w->next;
  }

  active_worksheet = worksheet;
  gdk_window_get_pointer(widget->window, NULL, NULL, &mods);
  if(!(mods & GDK_BUTTON3_MASK)) return;

  gtk_menu_popup(GTK_MENU(matrix_menu), NULL, NULL, NULL, NULL,
                 event->button, event->time);
}

void
sg_matrix_build_menu()
{
  /* EDIT MENU */

  sg_plugin_group_new("Matrix:Edit:");
  sg_plugin_new_c("Cut","Matrix:Edit:", sg_menu_cut);
  sg_plugin_new_c("Copy","Matrix:Edit:", sg_menu_copy);
  sg_plugin_new_c("Paste","Matrix:Edit:", sg_menu_paste);
  sg_plugin_new_c("Clear","Matrix:Edit:", sg_menu_clear);
  sg_plugin_new_c("Set as Begin","Matrix:Edit:", sg_menu_begin);
  sg_plugin_new_c("Set as End","Matrix:Edit:", sg_menu_begin);
  sg_plugin_new_c("Reset to full range","Matrix:Edit:", sg_menu_reset);
  sg_plugin_new_c("Clear matrix","Matrix:Edit:", sg_menu_clear_all);

 /* MATRIX MENU */

  sg_plugin_group_new("Matrix:Matrix:");
  sg_plugin_new_c("Set X/Y range","Matrix:Matrix:", sg_menu_set_range);
  sg_plugin_new_c("Set column values","Matrix:Matrix:", sg_menu_set_values);
  sg_plugin_new_c("Set matrix values","Matrix:Matrix:", sg_menu_set_mvalues);
  sg_plugin_new_c("Transpose","Matrix:Matrix:", sg_menu_transpose);
  sg_plugin_new_c("Convert to Worksheet","Matrix:Matrix:", sg_menu_convert);
  sg_plugin_new_c("Properties","Matrix:Matrix:", sg_menu_properties);
/*
  sg_plugin_new_c("Mask data","Matrix:Matrix:", sg_menu_mask);
*/

  /* COLUMN MENU */

  sg_plugin_group_new("Matrix:Column:");
  sg_plugin_new_c("Add new columns","Matrix:Column:", sg_menu_append_cols);
  sg_plugin_new_c("Insert columns","Matrix:Column:", sg_menu_insert_cols);
  sg_plugin_new_c("Remove columns","Matrix:Column:", sg_menu_remove_cols);

  /* ROW MENU */

  sg_plugin_group_new("Matrix:Row:");
  sg_plugin_new_c("Add new rows","Matrix:Row:", sg_menu_append_rows);
  sg_plugin_new_c("Insert rows","Matrix:Row:", sg_menu_insert_rows);
  sg_plugin_new_c("Remove rows","Matrix:Row:", sg_menu_remove_rows);

/* FILE MENU */

  sg_plugin_group_new("Matrix:Import:");
  sg_plugin_group_new("Matrix:Export:");
  sg_plugin_new_c("File","Matrix:Export:", sg_menu_export);
  sg_plugin_new_c("ASCII file","Matrix:Import:", sg_menu_import);
/*  sg_plugin_new_c("ASCII Import Options","Matrix:Import:", sg_menu_ascii);*/

}

static gpointer
sg_menu_append_rows(SGplugin *plugin)
{
  sg_append_dialog(active_worksheet, GTK_ORIENTATION_VERTICAL);
  return NULL;
}

static gpointer
sg_menu_append_cols(SGplugin *plugin)
{
  sg_append_dialog(active_worksheet, GTK_ORIENTATION_HORIZONTAL);
  return NULL;
}

static gpointer
sg_menu_insert_rows(SGplugin *plugin)
{
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(active_worksheet->sheet);
  range = sheet->range;

  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return NULL;

  sg_worksheet_insert_rows(active_worksheet, sheet->range.row0,
                           sheet->range.rowi - sheet->range.row0 + 1);
  return NULL;
}

static gpointer
sg_menu_insert_cols(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED){
    sg_worksheet_insert_columns(active_worksheet, sheet->range.col0,
                                sheet->range.coli - sheet->range.col0 + 1);
  }
  return NULL;
}

static gpointer
sg_menu_remove_rows(SGplugin *plugin)
{
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(active_worksheet->sheet);

  if(sheet->maxrow < 2) return NULL;

  range = sheet->range;
  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return NULL;

  sg_worksheet_delete_rows(active_worksheet, sheet->range.row0, nrows);
  return NULL;
}

static gpointer
sg_menu_remove_cols(SGplugin *plugin)
{
  GtkSheet *sheet;
  GtkSheetRange range;
  gint ncols;
  
  sheet = GTK_SHEET(active_worksheet->sheet);

  if(sheet->maxcol < 2) return NULL;

  range = sheet->range;
  ncols = range.coli - range.col0 + 1;

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
    sg_worksheet_delete_columns(active_worksheet, sheet->range.col0, ncols);

  return NULL;
}

static gpointer
sg_menu_begin(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);
  sg_worksheet_set_begin(active_worksheet, sheet->range.row0);
  
  return NULL;
}

static gpointer
sg_menu_end(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);
  sg_worksheet_set_end(active_worksheet, sheet->range.row0);
  
  return NULL;
}

static gpointer
sg_menu_reset(SGplugin *plugin)
{
  sg_worksheet_reset(active_worksheet);
  return NULL;
}

static gpointer
sg_menu_cut(SGplugin *plugin)
{
  sg_clipboard_copy(active_worksheet,TRUE);
  return NULL;
}

static gpointer
sg_menu_copy(SGplugin *plugin)
{
  sg_clipboard_copy(active_worksheet,FALSE);
  return NULL;
}

static gpointer
sg_menu_paste(SGplugin *plugin)
{
  sg_clipboard_paste(active_worksheet);
  return NULL;
}

static gpointer
sg_menu_clear(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);
  gtk_sheet_range_clear(sheet, &sheet->range);
  
  return NULL;
}

static gpointer
sg_menu_clear_all(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);
  gtk_sheet_range_clear(sheet, NULL);
  
  return NULL;
}

static gpointer
sg_menu_properties(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);

  sg_column_dialog(active_worksheet, 0);
     
  return NULL;
}

static gpointer
sg_menu_set_values(SGplugin *plugin)
{
  GtkSheet *sheet;
  sheet = GTK_SHEET(active_worksheet->sheet);
  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(active_worksheet, sheet->range.col0);

  return NULL;
}

static gpointer
sg_menu_set_mvalues(SGplugin *plugin)
{
  sg_xy_formula_dialog(active_worksheet);
  return NULL;
}

static gpointer
sg_menu_set_range(SGplugin *plugin)
{
  sg_matrix_dialog();
  return NULL;
}

static gpointer
sg_menu_mask(SGplugin *plugin)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(active_worksheet->sheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(active_worksheet, sheet->range.col0);

  return NULL;
}

static gpointer
sg_menu_export(SGplugin *plugin)
{
  sg_worksheet_export();
  return NULL;
}

static gpointer
sg_menu_import(SGplugin *plugin)
{
  sg_worksheet_import();
  return NULL;
}

static gpointer
sg_menu_ascii(SGplugin *plugin)
{
  sg_import_dialog(NULL,NULL);
  return NULL;
}


static gpointer
sg_menu_transpose(SGplugin *plugin)
{
  sg_matrix_transpose(active_worksheet);
  return NULL;
}

static gpointer
sg_menu_convert(SGplugin *plugin)
{
  sg_matrix_to_worksheet(active_worksheet);
  return NULL;
}
