/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include "sg_worksheet_file_tex.h"
#include "sg.h"

static void write_header_tex			(SGworksheetfile *file); 
static void write_footer_tex			(SGworksheetfile *file); 
static void write_col_title_tex			(SGworksheetfile *file, 
                                                 gint col);
static void write_cell_tex			(SGworksheetfile *file,  
                                                 gint row, gint col);
static void new_row_tex				(SGworksheetfile *file,
                                                 gint row); 
static void new_column_tex			(SGworksheetfile *file, 
                                                 gint col); 

gboolean
sg_worksheet_file_export_tex (SGworksheet *worksheet, 
                               gchar *filename,
                               GtkSheetRange *range)
{  
  SGworksheetfile *file;
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet->sheet);
  file = sg_worksheet_file_new(worksheet, filename);

  if ((file->file = fopen(file->filename, "w")) == NULL){
       g_warning("ERROR: Cannot write to file: %s", filename);
       g_free(file);
       return FALSE;
  }

  file->write_header = write_header_tex; 
  file->write_footer = write_footer_tex; 
  file->write_col_title = write_col_title_tex; 
  file->write_cell = write_cell_tex; 
  file->new_row = new_row_tex; 
  file->new_column = new_column_tex; 

  file->titlecolor = g_strdup("\"BBBBBB\"");
  file->cellcolor = g_strdup("\"FFFFFF\"");

  sg_worksheet_file_export(file, range);

  fclose(file->file);

  g_free(file->filename);
  g_free(file->titlecolor);
  g_free(file->cellcolor);
  g_free(file);

  return TRUE;
}

static void
write_header_tex(SGworksheetfile *file)
{
  gint col;

/*  
  fprintf(file->file,"\\documentstyle{article}");
  fprintf(file->file,"\\begin{document}");
*/
  fprintf(file->file,"\\begin{tabular}{");

  for(col = file->range.col0; col <= file->range.coli; col++)
    fprintf(file->file,"|c");

  fprintf(file->file,"|}\n\n");

  fprintf(file->file, "\\hline\n"); 
}

static void
write_footer_tex(SGworksheetfile *file)
{
  fprintf(file->file, "\\\\\n"); 
  fprintf(file->file, "\\hline\n"); 

  fprintf(file->file, "\n\\end{tabular}");
/*
  fprintf(file->file,"\\end{document}");
*/
}

static void
new_row_tex(SGworksheetfile *file, gint row)
{

  fprintf(file->file, "\\\\\n"); 
  fprintf(file->file, "\\hline\n"); 

}

static void
new_column_tex(SGworksheetfile *file, gint col)
{

  fprintf(file->file, " & "); 

}

static void
write_col_title_tex(SGworksheetfile *file, gint col) 
{
  gchar *title;
 
  title = GTK_SHEET(file->worksheet->sheet)->column[col].name;

  fprintf(file->file, "%s",title);
}

static void
write_cell_tex(SGworksheetfile *file, gint row, gint col)
{
  gchar *text;
  
  text = sg_worksheet_cell_get_text(file->worksheet, row, col);

  if(text && strlen(text) > 0)
           fprintf(file->file, "%s",text);
}

