#include <libgnomecanvas/gnome-canvas.h>
#include <libgnomecanvas/gnome-canvas-rect-ellipse.h>

#include "screem-linkview-util.h"

GnomeCanvasItem* node_draw( GnomeCanvasGroup *root, gdouble x,
			    gdouble y, gint node_type, gboolean legend )
{
	GnomeCanvasItem *node;
	GtkType type;
	
	type = gnome_canvas_ellipse_get_type();
	node = gnome_canvas_item_new( root, type,
				      "x1", x,
				      "y1", y,
				      "x2", x + 10.0,
				      "y2", y +10.0,
				      "outline_color", "black",
				      "width_units", 2.0,
				      NULL);
	switch( node_type ) {
	case EXTERNALNODE:
		gnome_canvas_item_set( node, "fill_color", "blue", NULL );
		break;
	case BADNODE:
		gnome_canvas_item_set( node, "fill_color", "red", NULL );
		break;
	case NONODE:
		gnome_canvas_item_set( node, "fill_color", "gray", NULL );
		break;
	case UPDATENODE:
		gnome_canvas_item_set( node, "fill_color", "yellow", NULL );
		break;
	case CHECKNODE:
		gnome_canvas_item_set( node, "fill_color", "orange", NULL );
		break;
	case GOODNODE:
	default:
		gnome_canvas_item_set( node, "fill_color", "green", NULL );
		break;	
	}

	return node;
}
