/*  

 The Linux and FreeBSD piece of code is heavily based upon 
 some code in timecop's <timecop@japan.co.jp> 
 "BubbleMon  dockapp 1.2"
 The FreeBSD code is orignally by oleg dashevskii 
 <od@iclub.nsu.ru> and changed to suit Sherman's aquarium

 Thanks goes out to bodnar istvan <bistvan@sliced.hu>
 for doing the FreeBSD testing for me.


 The code for Mac OS X & Darwin is written by 
 Ben Hines <bhines@alumni.ucsd.edu>
 Thanks!

 */

#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>

#include "defines.h"

#ifdef THERMOMETER

#include "sys_include.h"

#ifdef DARWIN
/* Mac OS X & Darwin */
#include <mach/mach_init.h>
#include <mach/mach_host.h>
#endif

#ifdef FREEBSD
#include <kvm.h>
#include <sys/dkstat.h>
#include <sys/vmmeter.h>
#include <sys/resource.h>
#include <sys/sysctl.h>
#include <vm/vm_param.h>

#define pagetob(size) ((size) << pageshift)

static kvm_t *kd = NULL;
static struct nlist nlst[] = {
    {"_cp_time", 0},
    {"_cnt", 0},
    {"_bufspace", 0},
    {0, 0}
};
static int pageshift;
int previous_total=0, previous_load=0;

#endif



/* Have the old ones global */
u_int64_t oload = 0, ototal = 0;
int firsttimes = 0, current = 0;
int cpu_average_list[CPUSMOOTHNESS];

#ifdef LINUX

/* returns current CPU load in percent, 0 to 100 */
int system_cpu(void)
{
    unsigned int cpuload;
    u_int64_t load, total;
    u_int64_t ab, ac, ad, ae;
    FILE *stat;
    int i;

    stat = fopen("/proc/stat", "r");
    fscanf(stat, "%*s %Ld %Ld %Ld %Ld", &ab, &ac, &ad, &ae);
    fclose(stat);

    if (firsttimes == 0) {
	for (i = 0; i < CPUSMOOTHNESS; i++)
	    cpu_average_list[i] = 0;
    }
    /* Wait until we have CPUSMOOTHNESS messures */
    if (firsttimes != CPUSMOOTHNESS)
	firsttimes++;

    /* Find out the CPU load */
    /* user + sys = load
     * total = total */
    load = ab + ac + ad;	/* cpu.user + cpu.sys; */
    total = ab + ac + ad + ae;	/* cpu.total; */

    /* Calculates and average from the last CPUSMOOTHNESS messures */
    if(total!=ototal)
	cpu_average_list[current] = (100 * (load - oload)) / (total - ototal);
    else
	cpu_average_list[current] = (load - oload);
	
    current++;
    if (current == CPUSMOOTHNESS)
	current = 0;

    oload = load;
    ototal = total;


    if (firsttimes != CPUSMOOTHNESS)
	return 0;

    cpuload = 0;

    for (i = 0; i < CPUSMOOTHNESS; i++)
	cpuload += cpu_average_list[i];
    return (cpuload / CPUSMOOTHNESS);
}
#endif

#ifdef DARWIN
/* Mac OS X & Darwin code written by Ben Hines <bhines@alumni.ucsd.edu> */
int system_cpu()
{
	processor_cpu_load_info_data_t *pinfo;
	mach_msg_type_number_t info_count;
	unsigned long composite_user, composite_nice, composite_sys, composite_idle;
   unsigned int cpuload, n_cpus;
   u_int64_t load, total;
	int i;
    if (firsttimes == 0) {
		for (i = 0; i < CPUSMOOTHNESS; i++)
			cpu_average_list[i] = 0;
    }
    /* Wait until we have CPUSMOOTHNESS messures */
    if (firsttimes != CPUSMOOTHNESS)
		firsttimes++;
	
	if (host_processor_info (mach_host_self (),
						  PROCESSOR_CPU_LOAD_INFO,
						  &n_cpus,
						  (processor_info_array_t*)&pinfo,
						  &info_count)) {
		return 0;
	}

	composite_user = composite_nice = composite_sys = composite_idle = 0;

	for (i = 0; i < n_cpus; i++) {
		composite_user  += pinfo[i].cpu_ticks [CPU_STATE_USER];
		composite_sys   += pinfo[i].cpu_ticks [CPU_STATE_SYSTEM];
		composite_idle  += pinfo[i].cpu_ticks [CPU_STATE_IDLE];
		composite_nice  += pinfo[i].cpu_ticks [CPU_STATE_NICE];
	}
	vm_deallocate (mach_task_self (), (vm_address_t) pinfo, info_count);

	/* user + sys = load
	* total = total */
	load = composite_user + composite_sys;	/* cpu.user + cpu.sys; */
	total = load + composite_idle + composite_nice;	/* cpu.total; */

	/* Calculates an average from the last CPUSMOOTHNESS messures */

    if(total!=ototal)
	cpu_average_list[current] = (100 * (load - oload)) / (total - ototal);
    else
	cpu_average_list[current] = (load - oload);

    current++;
    if (current == CPUSMOOTHNESS)
		current = 0;

    oload = load;
    ototal = total;

    if (firsttimes != CPUSMOOTHNESS)
		return 0;

    cpuload = 0;

    for (i = 0; i < CPUSMOOTHNESS; i++)
		cpuload += cpu_average_list[i];
    return (cpuload / CPUSMOOTHNESS);
	
}

#endif

#ifdef FREEBSD
int init_cpu_load()
{
    /* calculate page shift to convert pages into kilobytes */
    int pagesize = getpagesize();
    pageshift = 0;

    while (pagesize > 1) {
	pageshift++;
	pagesize >>= 1;
    }

    /* open kernel memory */
    kd = kvm_open(NULL, NULL, NULL, O_RDONLY, "kvm_open");

    if (kd == NULL) {
	puts("Could not open kernel virtual memory");
	return 1;
    }

    kvm_nlist(kd, nlst);

    if (nlst[0].n_type == 0 || nlst[1].n_type == 0 || nlst[2].n_type == 0) {
	puts("Error extracting symbols");
	return 2;
    }

    /* drop setgid & setuid (the latter should not be there really) */
    seteuid(getuid());
    setegid(getgid());

    if (geteuid() != getuid() || getegid() != getgid()) {
	puts("Unable to drop privileges");
	return 3;
    }

    return 0;
}

/* Returns the current CPU load in percent */
int system_cpu(void)
{
    int loadPercentage;
    int total, load;
    unsigned long int cpu_time[CPUSTATES];
    int i, cpuload;


    if (firsttimes == 0) {
	for (i = 0; i < CPUSMOOTHNESS; i++)
	    cpu_average_list[i] = 0;
    }
    /* Wait until we have CPUSMOOTHNESS messures */
    if (firsttimes != CPUSMOOTHNESS)
	firsttimes++;


    if (kvm_read(kd, nlst[0].n_value, &cpu_time, sizeof(cpu_time))
	!= sizeof(cpu_time))
	return 0;

    load = cpu_time[CP_USER] + cpu_time[CP_SYS] + cpu_time[CP_NICE];
    total = load + cpu_time[CP_IDLE];


    if(total!=previous_total)
	cpu_average_list[current] = (100 * (load - previous_load)) / (total - previous_total);
    else
	cpu_average_list[current] = (load - previous_load);
	
    current++;
    if (current == CPUSMOOTHNESS)
	current = 0;

    previous_load = load;
    previous_total = total;

    if (firsttimes != CPUSMOOTHNESS)
	return 0;

    cpuload = 0;

    for (i = 0; i < CPUSMOOTHNESS; i++)
	cpuload += cpu_average_list[i];
    return (cpuload / CPUSMOOTHNESS);

}


#endif

#endif
