/* # skkinput (Simple Kana-Kanji Input)
 * skkkip.h --- Kinput Protocol
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "skkmain.h"
#include "skkproto.h"
#include "SkkInput.h"

/*
 * ץȥ
 */
static void KIP_SendEndOfConversion( SKKInputRootNode *rNode ) ;
static int KIP_RemoveSkkInputCallback( SKKInputRootNode *rNode ) ;
static SKKInputRootNode *KIP_GetPopup
( Widget parent, Window request_window ) ;
static void KIP_messageConversionRequest_Handler
( Widget w, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void KIP_messageConversionEndRequest_Handler
( Widget w, XEvent *xevent, String *params, Cardinal *num_params ) ;

static SKKInputRootNode *KIP_FindFreeNode( Window req_window ) ;
static SKKInputRootNode *KIP_FindSkkInputNode( Window req_window ) ;

extern int convJWStoCT( char *str, unsigned char *xstr, int jisroman ) ;
extern int setSkkInputConversionCallback( SKKInputRootNode *rNode ) ;
extern int removeSkkInputConversionCallback( SKKInputRootNode *rNode ) ;
extern int skkinput_setSkkInputValues
( Widget gw, int flag, int cmode, int eggnl ) ;

/*
 * Хѿ
 */
static Atom KIP_convAtom ;	/* ܸϤѤ롣*/
static Atom KIP_propAtom ;
static Atom KIP_ctextAtom ;
static Atom KIP_reqAtom ;
static Atom KIP_notifyAtom ;
static Atom KIP_endAtom ;
static Atom KIP_endReqAtom ;

extern Atom wm_delete_window ;

/* Kinput Protocol Τ Actoin Table */
static XtActionsRec KIP_Actions[] = {
  { "beginConversion",	KIP_messageConversionRequest_Handler },
  { "endConversion",	KIP_messageConversionEndRequest_Handler },
} ;

/* Kinput Protocol Τ Translation Table */
static char KIP_Translations[] = 
"<Message>CONVERSION_REQUEST:     beginConversion()\n\
 <Message>CONVERSION_END_REQUEST: endConversion()\n" ;

/*
 * Kinput Protocol  Message 򴹤Ѥ Atom ؿ
 */
static void KIP_GetAtoms( Widget gw )
{
  Display *display = XtDisplay( gw ) ;

#define MakeAtom(s)	XInternAtom(display,s,False)

  /* Kinput Protocol ɬפȤ Atom 롣*/
  KIP_convAtom   = MakeAtom( "JAPANESE_CONVERSION" ) ;
  KIP_propAtom   = MakeAtom( "CONVERSION_STRING" ) ;
  KIP_ctextAtom  = MakeAtom( "COMPOUND_TEXT" ) ;
  KIP_reqAtom    = MakeAtom( "CONVERSION_REQUEST" ) ;
  KIP_notifyAtom = MakeAtom( "CONVERSION_NOTIFY" ) ;
  KIP_endAtom    = MakeAtom( "CONVERSION_END" ) ;
  KIP_endReqAtom = MakeAtom( "CONVERSIOIN_END_REQUEST" ) ;

#undef MakeAtom
  return ;
}

/*
 * Kinput Protocol Ѳǽˤ뤿νؿ
 */
int KIP_initialize( XtAppContext app_context, Widget gw )
{
  /* ޤѴΤ atom äơġ*/
  KIP_GetAtoms( gw ) ;
  /*  CONVERSION_REQUEST  OWNER ˤʤ롣*/
  XSetSelectionOwner( XtDisplay( gw ), KIP_convAtom, XtWindow( gw ),
		      CurrentTime ) ;
  /* ̵ Owner ˤʤ줿ɤȽꤹ롣*/
  if( XGetSelectionOwner
      ( XtDisplay( gw ), KIP_convAtom ) != XtWindow( gw ) ){
    /* Owner ˤʤʤäˤϡѴ׵Ȥ뤳ȤϤä *
     * ǤʤΤǡ褦ʤ餹롩 */
    fprintf( stderr, "Can't own selection.\n" ) ;
    return False ;
  }
  /* 륤٥ȤȤνؿ롣*/
  XtAppAddActions( app_context, KIP_Actions, XtNumber( KIP_Actions ) ) ;
  XtOverrideTranslations
    ( gw,  XtParseTranslationTable( KIP_Translations ) ) ;
  return True ;
}

/*
 * Kinput Protocol Ѵ׵ԤؤʸԤδؿ
 *-----
 * ʸ SkkInputWidget ƽФ뤿ᡢcallbackηˤʤ
 * Ƥ롣
 */
static int KIP_SendMessageToRequestorCallback
( Widget w, caddr_t client, caddr_t caller )
{
  SKKInputRootNode *rNode = ( SKKInputRootNode * )client ;
  char *text = ( char * )caller ;

  Atom	proptype ;
  int	propsize ;
  int	propformat ;
  caddr_t propvalue ;
  XClientMessageEvent	*ev = &( ( rNode->xevent ).xclient ) ;
  
  char *p ;

  /*
   * ǡ򥯥饤ȤꥯȤѴ
   */
  /*if (ev->data.l[2] == ctextAtom){ */
  /* compound text Ѵ */
  /*  comound text Ǥ \r ʤΤ  \n 
   * ѴƤ
   */
  for( p = text ; *p != '\0' ; p ++ )
    if( *p == '\r' )
      *p = '\n';
  proptype = KIP_ctextAtom ;
  propformat = 8 ;
  propsize = convJWStoCT( text, NULL, 0 ) ;
  if ( propsize <= 0 ){
#ifdef DEBUG_LV1
    fprintf( stderr, "Propsize <= 0 then return.\n" ) ;
#endif
    return 1 ;
  }
  propvalue = ( caddr_t )malloc( propsize * sizeof( unsigned char ) * 4 ) ;
  (void)convJWStoCT( text, (unsigned char *)propvalue, 0 ) ;
#ifdef DEBUG
  fprintf( stderr, "XChangeProperty : \"%s\" ... %d\n", propvalue, propsize ) ;
#endif

  /* Property ˷̤򥻥åȤ */
  XChangeProperty( XtDisplay( rNode->skkinp ), ( Window )ev->data.l[1],
		   ( Atom )ev->data.l[3], proptype, propformat,
		   PropModeAppend, propvalue, propsize ) ;
  free( propvalue ) ;
  return 0 ;
}					
					
/*
 * Kinput Protocol ǤѴ׵ԤؤѴλãؿ
 *-----
 *  SkkInputWidget Ѵ׵ԤΤ뤳ȤǤʤǤ롣
 * XSetArg ϤƤȤǤɤΤġȡResource 
 * ǤȤ̵ڤȤˤʤäƤޤäơ(;_;)
 * 줫顢ᥤ¦ǤⲿȤĤʤäƤΤΤäƤʤ̵¤
 * SkkInputWidget äƤޤȤˤʤ롣顢main  widget ξ
 * ΤäƤʤФʤʤ req_window  main ˴callback 
 *  main Τ뤳ȤˤʤäƤΤǤ롣
 */
static int KIP_EndMessageToRequestorCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  SKKInputRootNode *rNode = ( SKKInputRootNode * )client ;
  Arg arg[ 3 ] ;
  Cardinal i ;

  /* ѤʤʤäȤΤ餻롣*/
  rNode->probe        = False ;
  rNode->reserve      = False ;

  i = 0 ;
  XtSetArg( arg[ i ], XtNchatAdapter,    &rNode->chat_adapter ) ;
  i ++ ;  
  XtSetArg( arg[ i ], XtNeggLikeNewline, &rNode->eggnl ) ;
  i ++ ;  
  XtGetValues( rNode->skkinp, arg, i ) ;

  /* callback ˴롣*/
  KIP_RemoveSkkInputCallback( rNode ) ;
  removeSkkInputConversionCallback( rNode ) ;
  XFlush( XtDisplay( rNode->popup ) ) ;
  /* Pop Down 롣*/
  XtPopdown( rNode->popup ) ;

  /* λΤ롣Ƥ DestroyNotify ˤä˲Ƥ *
   * ˤƤϤθ¤ǤϤʤξˤ req_window ==    *
   * None ȤʤäƤ롣*/
  if( rNode->req_window != None ){
    KIP_SendEndOfConversion( rNode ) ;
#if 0
    /* Ѵ饤Ȥ鲿Ƥ̵뤹롣*/
    XSelectInput
      ( XtDisplay( rNode->popup ), rNode->req_window, NoEventMask ) ;
    /* ݥ󥿤򤭤᤹*/
    XSetInputFocus
      ( XtDisplay( rNode->popup ), rNode->req_window,
	RevertToParent, CurrentTime ) ;
#endif
  }
  return 0 ;
}

/*
 * 򲡤Ȥ٥Ȥ̤ؤžΤѤؿ
 */
static void KIP_KeyEventToRequestorCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  SKKInputRootNode *rNode = ( SKKInputRootNode *)client ;
  XEvent *xevent = ( XEvent *)caller ;

  /* եƤؤȥå롣*/
  xevent->xkey.window    = rNode->focus_window ;
  xevent->xkey.subwindow = None ;

  XSendEvent
    ( XtDisplay( gw ), xevent->xkey.window, False, NoEventMask, xevent ) ;
  return ;
}

/*
 * Kinput Protocol ǤѴȤԤȤȤ Widget Τ餻
 *  Callback  Kinput Protocol ꤹؿ
 *------
 * Τ餻ȤİäƤʬ¿ʬ callback ʤΤ顢
 * סġ C-h 줿Ȥȡ¾ˤ
 * פȻפ
 */
static int KIP_SetSkkInputCallback( SKKInputRootNode *rNode )
{
  /* ʸѴ׵ԤĤcallbackϿ*/
  XtAddCallback( rNode->skkinp, XtNfixNotify,
		 (XtCallbackProc)KIP_SendMessageToRequestorCallback,
		 (XtPointer)rNode) ;
  /* Ѵ׵ԤѴνλΤcallbackϿ*/
  XtAddCallback( rNode->skkinp, XtNendNotify,
		 (XtCallbackProc)KIP_EndMessageToRequestorCallback,
		 (XtPointer)rNode) ;
  /* Ѵ׵Ԥإ򲡤᤹callbackϿ*/
  XtAddCallback( rNode->skkinp, XtNkeybackNotify,
		 (XtCallbackProc)KIP_KeyEventToRequestorCallback,
		 (XtPointer)rNode) ;
  return 0 ;
}

static int KIP_RemoveSkkInputCallback( SKKInputRootNode *rNode )
{
  /* ʸѴ׵ԤĤcallbackϿ*/
  XtRemoveAllCallbacks( rNode->skkinp, XtNfixNotify ) ;
  /* Ѵ׵ԤѴνλΤcallbackϿ*/
  XtRemoveAllCallbacks( rNode->skkinp, XtNendNotify ) ;
  /* Ѵ׵Ԥإ򲡤᤹callbackϿ*/
  XtRemoveAllCallbacks( rNode->skkinp, XtNkeybackNotify ) ;
  return 0 ;
}

/*
 * Kinput Protocl Ѵ׵Ф饤ȤѴ׵μ
 * Τؿ
 */
static void KIP_SendConvNotify
( XEvent *xevent, Atom property, Window skkinputwin )
{
  XClientMessageEvent *ev = &( xevent->xclient ) ;
  XEvent event ;

  event.xclient.type         = ClientMessage ;
  event.xclient.window       = ev->data.l[ 1 ] ;
  event.xclient.message_type = KIP_notifyAtom ;
  event.xclient.format       = 32 ;
  event.xclient.data.l[0]    = KIP_convAtom ;
  event.xclient.data.l[1]    = ev->data.l[ 2 ] ;
  event.xclient.data.l[2]    = property ;
  event.xclient.data.l[3]    = skkinputwin ;

  XSendEvent( ev->display, ev->data.l[ 1 ], False, NoEventMask, &event ) ;
  return ;
}

/*
 * Kinput Protocol Ѵλ׵˽äƥ饤ȤȤ³λ
 * ؿ
 */
static void KIP_SendEndOfConversion( SKKInputRootNode *rNode )
{
  XEvent event ;

  event.xclient.type         = ClientMessage ;
  event.xclient.window       = rNode->req_window ;
  event.xclient.message_type = KIP_endAtom ;
  event.xclient.format       = 32 ;
  event.xclient.data.l[0]    = KIP_convAtom ;
  event.xclient.data.l[1]    = XtWindow( rNode->skkinp ) ;
  
  XSendEvent( XtDisplay( rNode->skkinp ), rNode->req_window,
	      False, NoEventMask, &event ) ;
  return ;
}

/*
 * Kinput Protocol Ȥå褿ΤɤȽ
 * ꤹؿ
 */
static int KIP_CorrectClientMessageP( Widget w, XEvent *xevent )
{
  XClientMessageEvent *ev = &xevent->xclient ;

#ifdef DEBUG
  fprintf( stderr, "Get Client Message. I check whether it is correct.\n" ) ;
  fflush( stderr ) ;
#endif

  /* åƤΤɤȽꤹ롣*/
  if( ev->window != XtWindow( w ) ||
      ev->format != 32 ||
      ev->data.l[ 0 ] != KIP_convAtom ){
    /* ʥåƤߤʤΤǡ̵뤷ޤ*/
    return  False ;
  }
  return True ;
}

/*
 * Kinput Protocol ˤѴ׵νؿ
 *-----
 * SkkInputWidget Conversion Methode  Kinput Protocol 
 * 롣
 */
static void KIP_messageConversionRequest_Handler
( Widget w, XEvent *xevent, String *params, Cardinal *num_params )
{
  SKKInputRootNode *rNode ;
  XClientMessageEvent *ev = &( xevent->xclient ) ;

#ifdef DEBUG
  fprintf( stderr, "KIP:begin-conversion.\n" ) ;
  fflush( stderr ) ;
#endif

  /* ʥåŤ̵뤷ƺ夲롣*/
  if( !KIP_CorrectClientMessageP( w, xevent ) )
    return ;

  /* Ƥ Window ̵ä齪λˤ롣*/
  if( ( rNode = KIP_GetPopup( w, ev->data.l[ 1 ] ) ) == NULL ){
    /* ϵƤ硢⤷Ϥʾ򵯤Ȥ *
     * ʤ롣*/
    return ;
  }
  /* λ׵ĤƤĤɬϺʬʤɡ*/
  rNode->xevent = *xevent ;
  rNode->xevent.xclient.data.l[ 2 ] = KIP_ctextAtom ;

  if( ev->data.l[3] == None )
    rNode->xevent.xclient.data.l[ 3 ] = KIP_propAtom ;

  /* ̵׵᤬̤äȤ client Τ롣*/
  KIP_SendConvNotify
    ( &( rNode->xevent ), rNode->xevent.xclient.data.l[3],
      XtWindow( rNode->skkinp ) ) ;
  return ;
}

/*
 * ѴλåνԤؿ
 */
static void KIP_messageConversionEndRequest_Handler
( Widget w, XEvent *xevent, String *params, Cardinal *num_params )
{
  XClientMessageEvent *cev = &( xevent->xclient ) ;
  SKKInputRootNode *rNode ;

#ifdef DEBUG
  fprintf( stderr, "KIP : end-conversion.\n" ) ;
  fflush( stderr ) ;
#endif

  /* ʥåŤ̵뤷ƺ夲롣*/
  if( !KIP_CorrectClientMessageP( w, xevent ) )
    return ;

  if( ( rNode = KIP_FindSkkInputNode( cev->data.l[ 1 ] ) ) == NULL ){
    /* ΤʤͤΤä㤤ʤΤǡŤ̵뤷ƺ *
     * 夲ޤ*/
    return ;
  }
  /* Widget ˴롣*/
  XtDestroyWidget( rNode->skkinp ) ;
  return ;
}

/*
 * client ׵˽äơѴѤ Window 򵯤ؿ
 */
static SKKInputRootNode *KIP_GetPopup
( Widget parent, Window request_window )
{
  SKKInputRootNode *rNode ;
  Arg arg[ 10 ] ;
  int i, is_popup_before ;

  /* ݤǤΤ ޤϡˤ׵­Ƥ *
   * Ĵ٤롣*/
  if( ( rNode = KIP_FindFreeNode( request_window ) ) == NULL ){
    return NULL ;
  }
  /* ˰ٵȤΤʤΡ */
  is_popup_before =
    ( rNode->req_window == request_window )? True : False ;
  /* ɤ뤫׵᤬ƤΤ򵭲Ƥ*/
  rNode->req_window   = request_window ;
  /* ɤʬʤɡrequestor ƱˤƤ*/
  rNode->focus_window = request_window ;

  rNode->probe        = True ;
  rNode->reserve      = True ;

  /* Ѵ Widget 롣*/
  i = 0;
  XtSetArg( arg[ i ], XtNinput, True ) ;
  i ++ ;
  XtSetArg( arg[ i ], XtNmappedWhenManaged, True ) ;
  i ++ ;
  XtSetArg( arg[ i ], XtNinitPosition,  ( is_popup_before )? False : True ) ;
  i ++ ;
  rNode->skkinp = XtCreateManagedWidget
    ( "Skkinput-client", skkinputWidgetClass, rNode->popup, arg, i ) ;
  /* values ġ*/
  skkinput_setSkkInputValues
    ( rNode->skkinp, is_popup_before, rNode->chat_adapter, rNode->eggnl ) ;
  
  /* SkkInputWidget ΥХåꤹ롣*/
  KIP_SetSkkInputCallback( rNode ) ;
  setSkkInputConversionCallback( rNode ) ;

  XFlush( XtDisplay( rNode->popup ) ) ;
  /* Window  Pop Up 롣Exclusive ˤȡ¾ Popup   *
   * ˥٥ȤȤʤʤäƤޤΤǡNonexclusive  *
   * 뤳ȡ*/
  XtPopup( rNode->popup, XtGrabNone ) ;
  XSelectInput
    ( XtDisplay( rNode->popup ), rNode->req_window, StructureNotifyMask ) ;

  /* Window Manager ΥåȤ褦ꤹ롣       *
   *  XSetWMProtocols ꤹˤϡPopup θǤʤܤ *
   * 롣 PopUp ¹Ԥޤǡºݤ Window ¸ߤʤ *
   * Ǥ롣*/
  (void) XSetWMProtocols( XtDisplay( rNode->popup ),
			  XtWindow( rNode->popup ), &wm_delete_window, 1 ) ;
  XtOverrideTranslations
    ( rNode->popup, XtParseTranslationTable( "<Message>WM_PROTOCOLS: \
stopConversion()\n" ) ) ;

  XtSetKeyboardFocus( rNode->popup, rNode->skkinp ) ;
  /* XtRealizeWidget( rNode->toplevel ) ; */
  return rNode ;
}

/*
 * Ƥ skkinput դƤˡѴ׵ƤƤޤؿ
 */
static SKKInputRootNode *KIP_FindFreeNode( Window req_window )
{
  int i ;
  SKKInputRootNode *rNode = NULL ;

  /* 롼׳ϡ*/
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    /* ޤΤΤ̵Ĵ٤롣*/
    if( skkinputs[ i ].req_window == req_window &&
	skkinputs[ i ].probe == True ){
      return NULL ;
    }
    /* ƤΡɤǡƤӽФ줿ΤФ餬ͥ衣*/
    if( skkinputs[ i ].req_window == req_window &&
	skkinputs[ i ].probe == False &&
	skkinputs[ i ].reserve == False ){
      rNode = &( skkinputs[ i ] ) ;
      break ;
    }
    /* ƤΡɤ⸫դƤ˶Ƥۡ*/
    if(	skkinputs[ i ].req_window == None &&
	skkinputs[ i ].probe == False &&
	skkinputs[ i ].reserve == False ){
      rNode = &( skkinputs[ i ] ) ;
      continue ;
    }
    /* ʤơİդʤäƤΤϡ */
    if( rNode == NULL &&
	skkinputs[ i ].probe == False &&
	skkinputs[ i ].reserve == False ){
      rNode = &( skkinputs[ i ] ) ;
      continue ;
    }
  }
  return rNode ;
}

/*
 * ׵ᤵ줿 Window Ѵ饤ȤǤ뤬¸ߤ뤫ɤĴ٤ؿ
 */
static SKKInputRootNode *KIP_FindSkkInputNode( Window req_window )
{
  int i ;
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    /* 뤬ƤʤС̵뤹뤷ʤ*/
    if( !skkinputs[ i ].probe )
      continue ;
    /* Ƥ顢ï׵˽äƤΤĴ٤롣*/
    if( skkinputs[ i ].req_window == req_window )
      return &( skkinputs[ i ] ) ;
  }
  /* ꤵ줿׵˽äƤԤϤʤä硣*/
  return NULL ;
}

