let report_error file_name lexbuf msg =
  let (lineno, start, finish) =
    Lex_policy_mls.lexeme_place lexbuf in
  let msg =
    Printf.sprintf
      "File \"%s\", line %d, characters %d-%d: %s"
      file_name lineno start finish msg in
  failwith msg

let report_parse_error file_name lexbuf =
  report_error file_name lexbuf "syntax error"

let open_in_or_stdin file_name =
  if file_name = "-" then
    stdin
  else
    open_in file_name

let read_policy file_name =
  let chan = open_in_or_stdin file_name in
  let lexbuf = Lexing.from_channel chan in
  Lex_policy_mls.init();
  try
    Parse_policy_mls.policy Lex_policy_mls.token lexbuf;
    close_in chan
  with Parsing.Parse_error ->
    close_in chan;
    report_parse_error file_name lexbuf
  | Failure s ->
    close_in chan;
    report_error file_name lexbuf s

let read_mls file_name =
  let chan = open_in_or_stdin file_name in
  let lexbuf = Lexing.from_channel chan in
  Lex_policy_mls.init();
  try
    Parse_policy_mls.mls Lex_policy_mls.token lexbuf;
    close_in chan
  with Parsing.Parse_error ->
    close_in chan;
    report_parse_error file_name lexbuf
  | Failure s ->
    close_in chan;
    report_error file_name lexbuf s
