/*
 * SpanDSP - a series of DSP components for telephony
 *
 * faxfont.h - a simple fixed pitch font for FAX headers
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: faxfont.h,v 1.1 2004/06/12 12:48:47 steveu Exp $
 */

static const uint32_t header_font[256][16] =
{
    { /* 0 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 1 */
        0x0,
        0x0,
        0x3FFC,
        0xC003,
        0xCC33,
        0xC003,
        0xC003,
        0xCFF3,
        0xC3C3,
        0xC003,
        0xC003,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 2 */
        0x0,
        0x0,
        0x3FFC,
        0xFFFF,
        0xF3CF,
        0xFFFF,
        0xFFFF,
        0xF00F,
        0xFC3F,
        0xFFFF,
        0xFFFF,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 3 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x1E78,
        0x7FFE,
        0x7FFE,
        0x7FFE,
        0x7FFE,
        0x1FF8,
        0x7E0,
        0x180,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 4 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x180,
        0x7E0,
        0x1FF8,
        0x7FFE,
        0x1FF8,
        0x7E0,
        0x180,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 5 */
        0x0,
        0x0,
        0x0,
        0x3C0,
        0xFF0,
        0xFF0,
        0x7C3E,
        0x7C3E,
        0x7C3E,
        0x63C6,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 6 */
        0x0,
        0x0,
        0x0,
        0x180,
        0x7E0,
        0x1FF8,
        0x7FFE,
        0x7FFE,
        0x1FF8,
        0x180,
        0x180,
        0x7E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 7 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0xFF0,
        0xFF0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 8 */
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFC3F,
        0xF00F,
        0xF00F,
        0xFC3F,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
    },
    { /* 9 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFF0,
        0x3C3C,
        0x300C,
        0x300C,
        0x3C3C,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 10 */
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xF00F,
        0xC3C3,
        0xCFF3,
        0xCFF3,
        0xC3C3,
        0xF00F,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
    },
    { /* 11 */
        0x0,
        0x0,
        0x1FE,
        0x7E,
        0x1F6,
        0x786,
        0x1FE0,
        0x3870,
        0x3870,
        0x3870,
        0x3870,
        0x1FE0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 12 */
        0x0,
        0x0,
        0xFF0,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0xFF0,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 13 */
        0x0,
        0x0,
        0xFFE,
        0xF0E,
        0xFFE,
        0xE00,
        0xE00,
        0xE00,
        0xE00,
        0x3E00,
        0x7E00,
        0x3C00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 14 */
        0x0,
        0x0,
        0x1FFE,
        0x1C0E,
        0x1FFE,
        0x1C0E,
        0x1C0E,
        0x1C0E,
        0x1C0E,
        0x1C1E,
        0x3C3E,
        0x7C1C,
        0x3800,
        0x0,
        0x0,
        0x0,
    },
    { /* 15 */
        0x0,
        0x0,
        0x0,
        0x4002,
        0x23C4,
        0x13C8,
        0xE70,
        0x781E,
        0xE70,
        0x13C8,
        0x23C4,
        0x4002,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 16 */
        0x0,
        0x3000,
        0x3C00,
        0x3F00,
        0x3FC0,
        0x3FF0,
        0x3FF8,
        0x3FF0,
        0x3FC0,
        0x3F00,
        0x3C00,
        0x3000,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 17 */
        0x0,
        0xC,
        0x3C,
        0xFC,
        0x3FC,
        0xFFC,
        0x1FFC,
        0xFFC,
        0x3FC,
        0xFC,
        0x3C,
        0xC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 18 */
        0x0,
        0x180,
        0x3C0,
        0xFF0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0xFF0,
        0x3C0,
        0x180,
        0x0,
        0x0,
        0x0,
    },
    { /* 19 */
        0x0,
        0x0,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x0,
        0x3C3C,
        0x3C3C,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 20 */
        0x0,
        0x0,
        0x3FFE,
        0x71CE,
        0x71CE,
        0x71CE,
        0x3FCE,
        0x1CE,
        0x1CE,
        0x1CE,
        0x1CE,
        0x1CE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 21 */
        0x0,
        0x3FF0,
        0x7038,
        0x3C18,
        0xFC0,
        0x3CF0,
        0x7038,
        0x7038,
        0x7038,
        0x3CF0,
        0xFC0,
        0x60F0,
        0x7038,
        0x3FF0,
        0x0,
        0x0,
    },
    { /* 22 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3FFC,
        0x3FFC,
        0x3FFC,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 23 */
        0x0,
        0x180,
        0x3C0,
        0xFF0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0xFF0,
        0x3C0,
        0x180,
        0x3FFC,
        0x0,
        0x0,
    },
    { /* 24 */
        0x0,
        0x0,
        0x180,
        0x3C0,
        0xFF0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
    },
    { /* 25 */
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0xFF0,
        0x3C0,
        0x180,
        0x0,
        0x0,
        0x0,
    },
    { /* 26 */
        0x0,
        0x0,
        0x0,
        0x40,
        0x60,
        0x70,
        0x78,
        0x3FFC,
        0x78,
        0x70,
        0x60,
        0x40,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 27 */
        0x0,
        0x0,
        0x0,
        0x200,
        0x600,
        0xE00,
        0x1E00,
        0x3FFC,
        0x1E00,
        0xE00,
        0x600,
        0x200,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 28 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3800,
        0x3800,
        0x3800,
        0x3800,
        0x3FFE,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 29 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x420,
        0xC30,
        0x1C38,
        0x3FFC,
        0x1C38,
        0xC30,
        0x420,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 30 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x180,
        0x7E0,
        0x7E0,
        0x1FF8,
        0x1FF8,
        0x7FFE,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 31 */
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFC,
        0xFFFC,
        0x3FF0,
        0x3FF0,
        0xFC0,
        0xFC0,
        0x300,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 32 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 33 */
        0x0,
        0x0,
        0x3C0,
        0x7E0,
        0x7E0,
        0x7E0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 34 */
        0x0,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0xC30,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 35 */
        0x0,
        0x0,
        0x0,
        0x1C38,
        0x1C38,
        0x7FFE,
        0x1C38,
        0x1C38,
        0x1C38,
        0x7FFE,
        0x1C38,
        0x1C38,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 36 */
        0x0,
        0x1E0,
        0x1E0,
        0x1FF8,
        0x781E,
        0x7806,
        0x7800,
        0x1FF8,
        0x1E,
        0x601E,
        0x781E,
        0x1FF8,
        0x1E0,
        0x1E0,
        0x0,
        0x0,
    },
    { /* 37 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x7806,
        0x781E,
        0x78,
        0x1E0,
        0x780,
        0x1E00,
        0x781E,
        0x601E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 38 */
        0x0,
        0x0,
        0x7E0,
        0x1E78,
        0x1E78,
        0x7E0,
        0x1F9E,
        0x79F8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 39 */
        0x0,
        0xF00,
        0xF00,
        0xF00,
        0x3C00,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 40 */
        0x0,
        0x0,
        0xF0,
        0x3C0,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0x3C0,
        0xF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 41 */
        0x0,
        0x0,
        0xF00,
        0x3C0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0x3C0,
        0xF00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 42 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C3C,
        0xFF0,
        0x7FFE,
        0xFF0,
        0x3C3C,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 43 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 44 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xF00,
        0x0,
        0x0,
        0x0,
    },
    { /* 45 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 46 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 47 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x6,
        0x1E,
        0x78,
        0x1E0,
        0x780,
        0x1E00,
        0x7800,
        0x6000,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 48 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x787E,
        0x799E,
        0x799E,
        0x7E1E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 49 */
        0x0,
        0x0,
        0x3C0,
        0xFC0,
        0x3FC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 50 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x1E,
        0x78,
        0x1E0,
        0x780,
        0x1E00,
        0x7800,
        0x781E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 51 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x1E,
        0x1E,
        0x7F8,
        0x1E,
        0x1E,
        0x1E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 52 */
        0x0,
        0x0,
        0x78,
        0x1F8,
        0x7F8,
        0x1E78,
        0x7878,
        0x7FFE,
        0x78,
        0x78,
        0x78,
        0x1FE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 53 */
        0x0,
        0x0,
        0x7FFE,
        0x7800,
        0x7800,
        0x7800,
        0x7FF8,
        0x7E,
        0x1E,
        0x1E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 54 */
        0x0,
        0x0,
        0x7E0,
        0x1E00,
        0x7800,
        0x7800,
        0x7FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 55 */
        0x0,
        0x0,
        0x7FFE,
        0x781E,
        0x1E,
        0x1E,
        0x78,
        0x1E0,
        0x780,
        0x780,
        0x780,
        0x780,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 56 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 57 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x1FFE,
        0x1E,
        0x1E,
        0x1E,
        0x78,
        0x1FE0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 58 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 59 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0xF00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 60 */
        0x0,
        0x0,
        0x0,
        0x3C,
        0xF0,
        0x3C0,
        0xF00,
        0x3C00,
        0xF00,
        0x3C0,
        0xF0,
        0x3C,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 61 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3FFC,
        0x0,
        0x0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 62 */
        0x0,
        0x0,
        0x0,
        0x3C00,
        0xF00,
        0x3C0,
        0xF0,
        0x3C,
        0xF0,
        0x3C0,
        0xF00,
        0x3C00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 63 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x78,
        0x1E0,
        0x1E0,
        0x1E0,
        0x0,
        0x1E0,
        0x1E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 64 */
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x79FE,
        0x79FE,
        0x79FE,
        0x79F8,
        0x7800,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 65 */
        0x0,
        0x0,
        0x180,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x7FFE,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 66 */
        0x0,
        0x0,
        0x7FF8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1FF8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x7FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 67 */
        0x0,
        0x0,
        0x7F8,
        0x1E1E,
        0x7806,
        0x7800,
        0x7800,
        0x7800,
        0x7800,
        0x7806,
        0x1E1E,
        0x7F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 68 */
        0x0,
        0x0,
        0x7FE0,
        0x1E78,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E78,
        0x7FE0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 69 */
        0x0,
        0x0,
        0x7FFE,
        0x1E1E,
        0x1E06,
        0x1E60,
        0x1FE0,
        0x1E60,
        0x1E00,
        0x1E06,
        0x1E1E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 70 */
        0x0,
        0x0,
        0x7FFE,
        0x1E1E,
        0x1E06,
        0x1E60,
        0x1FE0,
        0x1E60,
        0x1E00,
        0x1E00,
        0x1E00,
        0x7F80,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 71 */
        0x0,
        0x0,
        0x7F8,
        0x1E1E,
        0x7806,
        0x7800,
        0x7800,
        0x79FE,
        0x781E,
        0x781E,
        0x1E1E,
        0x7E6,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 72 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x7FFE,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 73 */
        0x0,
        0x0,
        0x7F8,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x7F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 74 */
        0x0,
        0x0,
        0x1FE,
        0x78,
        0x78,
        0x78,
        0x78,
        0x78,
        0x7878,
        0x7878,
        0x7878,
        0x1FE0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 75 */
        0x0,
        0x0,
        0x7E1E,
        0x1E1E,
        0x1E78,
        0x1E78,
        0x1FE0,
        0x1FE0,
        0x1E78,
        0x1E1E,
        0x1E1E,
        0x7E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 76 */
        0x0,
        0x0,
        0x7F80,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E06,
        0x1E1E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 77 */
        0x0,
        0x0,
        0x781E,
        0x7E7E,
        0x7FFE,
        0x7FFE,
        0x799E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 78 */
        0x0,
        0x0,
        0x781E,
        0x7E1E,
        0x7F9E,
        0x7FFE,
        0x79FE,
        0x787E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 79 */
        0x0,
        0x0,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1E78,
        0x7E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 80 */
        0x0,
        0x0,
        0x7FF8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1FF8,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x7F80,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 81 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x799E,
        0x79FE,
        0x1FF8,
        0x78,
        0x7E,
        0x0,
        0x0,
    },
    { /* 82 */
        0x0,
        0x0,
        0x7FF8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1FF8,
        0x1E78,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x7E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 83 */
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x1E00,
        0x7E0,
        0x78,
        0x1E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 84 */
        0x0,
        0x0,
        0x1FFE,
        0x1FFE,
        0x19E6,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x7F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 85 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 86 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1E78,
        0x7E0,
        0x180,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 87 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x799E,
        0x799E,
        0x7FFE,
        0x1E78,
        0x1E78,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 88 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x1E78,
        0x1E78,
        0x7E0,
        0x7E0,
        0x1E78,
        0x1E78,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 89 */
        0x0,
        0x0,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0xFF0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 90 */
        0x0,
        0x0,
        0x7FFE,
        0x781E,
        0x601E,
        0x78,
        0x1E0,
        0x780,
        0x1E00,
        0x7806,
        0x781E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 91 */
        0x0,
        0x0,
        0xFF0,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xF00,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 92 */
        0x0,
        0x0,
        0x0,
        0x6000,
        0x7800,
        0x7E00,
        0x1F80,
        0x7E0,
        0x1F8,
        0x7E,
        0x1E,
        0x6,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 93 */
        0x0,
        0x0,
        0xFF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 94 */
        0x180,
        0x7E0,
        0x1E78,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 95 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x0,
        0x0,
    },
    { /* 96 */
        0xF00,
        0xF00,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 97 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 98 */
        0x0,
        0x0,
        0x7E00,
        0x1E00,
        0x1E00,
        0x1FE0,
        0x1E78,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x79F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 99 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x7800,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 100 */
        0x0,
        0x0,
        0x1F8,
        0x78,
        0x78,
        0x7F8,
        0x1E78,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 101 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x7FFE,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 102 */
        0x0,
        0x0,
        0x7E0,
        0x1E78,
        0x1E18,
        0x1E00,
        0x7F80,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x7F80,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 103 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1F9E,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1FF8,
        0x78,
        0x7878,
        0x1FE0,
        0x0,
    },
    { /* 104 */
        0x0,
        0x0,
        0x7E00,
        0x1E00,
        0x1E00,
        0x1E78,
        0x1F9E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x7E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 105 */
        0x0,
        0x0,
        0x1E0,
        0x1E0,
        0x0,
        0x7E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x7F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 106 */
        0x0,
        0x0,
        0x1E,
        0x1E,
        0x0,
        0x7E,
        0x1E,
        0x1E,
        0x1E,
        0x1E,
        0x1E,
        0x1E,
        0x1E1E,
        0x1E1E,
        0x7F8,
        0x0,
    },
    { /* 107 */
        0x0,
        0x0,
        0x7E00,
        0x1E00,
        0x1E00,
        0x1E1E,
        0x1E78,
        0x1FE0,
        0x1FE0,
        0x1E78,
        0x1E1E,
        0x7E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 108 */
        0x0,
        0x0,
        0x7E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x7F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 109 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7E78,
        0x7FFE,
        0x799E,
        0x799E,
        0x799E,
        0x799E,
        0x799E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 110 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x79F8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 111 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 112 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x79F8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1FF8,
        0x1E00,
        0x1E00,
        0x7F80,
        0x0,
    },
    { /* 113 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1F9E,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1FF8,
        0x78,
        0x78,
        0x1FE,
        0x0,
    },
    { /* 114 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x79F8,
        0x1F9E,
        0x1E06,
        0x1E00,
        0x1E00,
        0x1E00,
        0x7F80,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 115 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x1E00,
        0x7E0,
        0x78,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 116 */
        0x0,
        0x0,
        0x180,
        0x780,
        0x780,
        0x7FF8,
        0x780,
        0x780,
        0x780,
        0x780,
        0x79E,
        0x1F8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 117 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 118 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x7F8,
        0x1E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 119 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x799E,
        0x799E,
        0x7FFE,
        0x1E78,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 120 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x781E,
        0x1E78,
        0x7E0,
        0x7E0,
        0x7E0,
        0x1E78,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 121 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FFE,
        0x1E,
        0x78,
        0x7FE0,
        0x0,
    },
    { /* 122 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7FFE,
        0x7878,
        0x1E0,
        0x780,
        0x1E00,
        0x781E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 123 */
        0x0,
        0x0,
        0xFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0xF00,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 124 */
        0x0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x0,
    },
    { /* 125 */
        0x0,
        0x0,
        0x3F00,
        0x3C0,
        0x3C0,
        0x3C0,
        0xF0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3F00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 126 */
        0x0,
        0x0,
        0x1F9E,
        0x79F8,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 127 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x180,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x781E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 128 */
        0x0,
        0x0,
        0x7F8,
        0x1E1E,
        0x7806,
        0x7800,
        0x7800,
        0x7800,
        0x7806,
        0x1E1E,
        0x7F8,
        0x78,
        0x1E,
        0x1FF8,
        0x0,
        0x0,
    },
    { /* 129 */
        0x0,
        0x0,
        0x7878,
        0x7878,
        0x0,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 130 */
        0x0,
        0x78,
        0x1E0,
        0x780,
        0x0,
        0x1FF8,
        0x781E,
        0x7FFE,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 131 */
        0x0,
        0x180,
        0x7E0,
        0x1E78,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 132 */
        0x0,
        0x0,
        0x7878,
        0x7878,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 133 */
        0x0,
        0x1E00,
        0x780,
        0x1E0,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 134 */
        0x0,
        0x7E0,
        0x1E78,
        0x7E0,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 135 */
        0x0,
        0x0,
        0x0,
        0x0,
        0xFF0,
        0x3C3C,
        0x3C00,
        0x3C00,
        0x3C3C,
        0xFF0,
        0xF0,
        0x3C,
        0xFF0,
        0x0,
        0x0,
        0x0,
    },
    { /* 136 */
        0x0,
        0x180,
        0x7E0,
        0x1E78,
        0x0,
        0x1FF8,
        0x781E,
        0x7FFE,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 137 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x0,
        0x1FF8,
        0x781E,
        0x7FFE,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 138 */
        0x0,
        0x1E00,
        0x780,
        0x1E0,
        0x0,
        0x1FF8,
        0x781E,
        0x7FFE,
        0x7800,
        0x7800,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 139 */
        0x0,
        0x0,
        0x3C3C,
        0x3C3C,
        0x0,
        0xFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 140 */
        0x0,
        0x3C0,
        0xFF0,
        0x3C3C,
        0x0,
        0xFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 141 */
        0x0,
        0x3C00,
        0xF00,
        0x3C0,
        0x0,
        0xFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 142 */
        0x0,
        0x781E,
        0x781E,
        0x180,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x7FFE,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 143 */
        0x7E0,
        0x1E78,
        0x7E0,
        0x0,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x7FFE,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 144 */
        0x1E0,
        0x780,
        0x1E00,
        0x0,
        0x7FFE,
        0x1E1E,
        0x1E00,
        0x1FF8,
        0x1E00,
        0x1E00,
        0x1E1E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 145 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7878,
        0x1F9E,
        0x79E,
        0x1FFE,
        0x79E0,
        0x79E0,
        0x1E7E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 146 */
        0x0,
        0x0,
        0x7FE,
        0x1E78,
        0x7878,
        0x7878,
        0x7FFE,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x787E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 147 */
        0x0,
        0x180,
        0x7E0,
        0x1E78,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 148 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 149 */
        0x0,
        0x1E00,
        0x780,
        0x1E0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 150 */
        0x0,
        0x780,
        0x1FE0,
        0x7878,
        0x0,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 151 */
        0x0,
        0x1E00,
        0x780,
        0x1E0,
        0x0,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 152 */
        0x0,
        0x0,
        0x781E,
        0x781E,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FFE,
        0x1E,
        0x78,
        0x1FE0,
        0x0,
    },
    { /* 153 */
        0x0,
        0x781E,
        0x781E,
        0x0,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1E78,
        0x7E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 154 */
        0x0,
        0x781E,
        0x781E,
        0x0,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 155 */
        0x0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x3C3C,
        0x3C00,
        0x3C00,
        0x3C00,
        0x3C3C,
        0xFF0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 156 */
        0x0,
        0x7E0,
        0x1E78,
        0x1E18,
        0x1E00,
        0x7F80,
        0x1E00,
        0x1E00,
        0x1E00,
        0x1E00,
        0x7E1E,
        0x7FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 157 */
        0x0,
        0x0,
        0x3C3C,
        0x3C3C,
        0xFF0,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 158 */
        0x0,
        0x7FE0,
        0x7878,
        0x7878,
        0x7FE0,
        0x7818,
        0x7878,
        0x79FE,
        0x7878,
        0x7878,
        0x7878,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 159 */
        0x0,
        0xFC,
        0x3CF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xF3C0,
        0x3F00,
        0x0,
        0x0,
    },
    { /* 160 */
        0x0,
        0x1E0,
        0x780,
        0x1E00,
        0x0,
        0x1FE0,
        0x78,
        0x1FF8,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 161 */
        0x0,
        0xF0,
        0x3C0,
        0xF00,
        0x0,
        0xFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 162 */
        0x0,
        0x1E0,
        0x780,
        0x1E00,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 163 */
        0x0,
        0x1E0,
        0x780,
        0x1E00,
        0x0,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x7878,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 164 */
        0x0,
        0x0,
        0x1F9E,
        0x79F8,
        0x0,
        0x79F8,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 165 */
        0x1F9E,
        0x79F8,
        0x0,
        0x781E,
        0x7E1E,
        0x7F9E,
        0x7FFE,
        0x79FE,
        0x787E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 166 */
        0x0,
        0xFF0,
        0x3CF0,
        0x3CF0,
        0xFFC,
        0x0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 167 */
        0x0,
        0x7E0,
        0x1E78,
        0x1E78,
        0x7E0,
        0x0,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 168 */
        0x0,
        0x0,
        0x780,
        0x780,
        0x0,
        0x780,
        0x780,
        0x1E00,
        0x7800,
        0x781E,
        0x781E,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 169 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFC,
        0xF000,
        0xF000,
        0xF000,
        0xF000,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 170 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFC,
        0x3C,
        0x3C,
        0x3C,
        0x3C,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 171 */
        0x0,
        0x7000,
        0x7000,
        0x700C,
        0x703C,
        0x70F0,
        0x3C0,
        0xF00,
        0x3C00,
        0xF0FC,
        0xC30E,
        0x3C,
        0xF0,
        0x3FE,
        0x0,
        0x0,
    },
    { /* 172 */
        0x0,
        0x7000,
        0x7000,
        0x700C,
        0x703C,
        0x70F0,
        0x3C0,
        0xF00,
        0x3C3C,
        0xF0FC,
        0xC38C,
        0x7FE,
        0x3C,
        0xFE,
        0x0,
        0x0,
    },
    { /* 173 */
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x7E0,
        0x7E0,
        0x7E0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 174 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xE0E,
        0x3C3C,
        0x7070,
        0x3C3C,
        0xE0E,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 175 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7070,
        0x3C3C,
        0xE0E,
        0x3C3C,
        0x7070,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 176 */
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
        0x303,
        0x3030,
    },
    { /* 177 */
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
        0xAAAA,
        0x5555,
    },
    { /* 178 */
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
        0xF3F3,
        0x3F3F,
    },
    { /* 179 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 180 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 181 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFC0,
        0x3C0,
        0xFFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 182 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 183 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFC,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 184 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFC0,
        0x3C0,
        0xFFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 185 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFF3C,
        0x3C,
        0xFF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 186 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 187 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFC,
        0x3C,
        0xFF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 188 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFF3C,
        0x3C,
        0xFFFC,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 189 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFFFC,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 190 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFC0,
        0x3C0,
        0xFFC0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 191 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFC0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 192 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 193 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 194 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 195 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 196 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 197 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFFF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 198 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FF,
        0x3C0,
        0x3FF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 199 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3F,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 200 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3F,
        0xF00,
        0xFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 201 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFF,
        0xF00,
        0xF3F,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 202 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFF3F,
        0x0,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 203 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x0,
        0xFF3F,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 204 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3F,
        0xF00,
        0xF3F,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 205 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x0,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 206 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFF3F,
        0x0,
        0xFF3F,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 207 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFFF,
        0x0,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 208 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 209 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0x0,
        0xFFFF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 210 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 211 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 212 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3FF,
        0x3C0,
        0x3FF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 213 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3FF,
        0x3C0,
        0x3FF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 214 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFF,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 215 */
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xFFFF,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
        0xF3C,
    },
    { /* 216 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFFF,
        0x3C0,
        0xFFFF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 217 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xFFC0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 218 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3FF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 219 */
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
    },
    { /* 220 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
    },
    { /* 221 */
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
        0xFF00,
    },
    { /* 222 */
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
        0xFF,
    },
    { /* 223 */
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0xFFFF,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 224 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1F9E,
        0x79F8,
        0x79E0,
        0x79E0,
        0x79E0,
        0x79F8,
        0x1F9E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 225 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x7FF8,
        0x781E,
        0x7FF8,
        0x781E,
        0x781E,
        0x7FF8,
        0x7800,
        0x7800,
        0x7800,
        0x0,
        0x0,
    },
    { /* 226 */
        0x0,
        0x0,
        0x7FFE,
        0x781E,
        0x781E,
        0x7800,
        0x7800,
        0x7800,
        0x7800,
        0x7800,
        0x7800,
        0x7800,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 227 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x7FFE,
        0x7FFE,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 228 */
        0x0,
        0x0,
        0x0,
        0x7FFE,
        0x781E,
        0x1E00,
        0x780,
        0x1E0,
        0x780,
        0x1E00,
        0x781E,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 229 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FFE,
        0x79E0,
        0x79E0,
        0x79E0,
        0x79E0,
        0x79E0,
        0x1F80,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 230 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1E1E,
        0x1FF8,
        0x1E00,
        0x1E00,
        0x7800,
        0x0,
        0x0,
        0x0,
    },
    { /* 231 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x1F9E,
        0x79F8,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x1E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 232 */
        0x0,
        0x0,
        0x0,
        0x3FFC,
        0x3C0,
        0xFF0,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0xFF0,
        0x3C0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 233 */
        0x0,
        0x0,
        0x0,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x7FFE,
        0x781E,
        0x781E,
        0x1E78,
        0x7E0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 234 */
        0x0,
        0x0,
        0x7E0,
        0x1E78,
        0x781E,
        0x781E,
        0x781E,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x7E7E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 235 */
        0x0,
        0x0,
        0x3FC,
        0xF00,
        0x3C0,
        0xF0,
        0xFFC,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0x3C3C,
        0xFF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 236 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3E7C,
        0x73CE,
        0x73CE,
        0x73CE,
        0x3E7C,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 237 */
        0x0,
        0x0,
        0x0,
        0xF,
        0x3C,
        0x3FFC,
        0xF0FF,
        0xF3CF,
        0xFF0F,
        0x3FFC,
        0x3C00,
        0xF000,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 238 */
        0x0,
        0x0,
        0x3F0,
        0xF00,
        0x1C00,
        0x1C00,
        0x1FF0,
        0x1C00,
        0x1C00,
        0x1C00,
        0xF00,
        0x3F0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 239 */
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x781E,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 240 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x7FFE,
        0x0,
        0x0,
        0x7FFE,
        0x0,
        0x0,
        0x7FFE,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 241 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x3FFC,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x3FFC,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 242 */
        0x0,
        0x0,
        0x0,
        0xF00,
        0x3C0,
        0xF0,
        0x38,
        0xF0,
        0x3C0,
        0xF00,
        0x0,
        0xFF8,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 243 */
        0x0,
        0x0,
        0x0,
        0xF0,
        0x3C0,
        0xF00,
        0x1C00,
        0xF00,
        0x3C0,
        0xF0,
        0x0,
        0x1FF0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 244 */
        0x0,
        0x0,
        0xFC,
        0x3CF,
        0x3CF,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
    },
    { /* 245 */
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0x3C0,
        0xF3C0,
        0xF3C0,
        0xF3C0,
        0x3F00,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 246 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x3FFC,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 247 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x1F9E,
        0x79F8,
        0x0,
        0x1F9E,
        0x79F8,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 248 */
        0x0,
        0x7E0,
        0x1E78,
        0x1E78,
        0x7E0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 249 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 250 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x3C0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 251 */
        0x0,
        0xFF,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0xF0,
        0x70F0,
        0x38F0,
        0x1CF0,
        0xFF0,
        0x3F0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 252 */
        0x0,
        0x79E0,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x1E78,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 253 */
        0x0,
        0x1F80,
        0x61E0,
        0x780,
        0x1E00,
        0x7860,
        0x7FE0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 254 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x1FF8,
        0x1FF8,
        0x1FF8,
        0x1FF8,
        0x1FF8,
        0x1FF8,
        0x1FF8,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
    { /* 255 */
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    },
};
