/* @(#)allocax.h	1.3 03/07/15 Copyright 2002 J. Schilling */
/*
 *	Definitions for users of alloca()
 *
 *	Important: #include this directly after <mconfig.h>
 *	and before any other include file.
 *	See comment in _AIX part below.
 *
 *	Copyright (c) 2002 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */


#ifndef	_ALLOCAX_H
#define	_ALLOCAX_H

#ifdef __GNUC__
#	ifndef	alloca
#		define	alloca(s)	__builtin_alloca(s)
#	endif
#else
#	ifdef _MSC_VER
#		include <malloc.h>
#		define alloca _alloca
#	else
#		if HAVE_ALLOCA_H
#			include <alloca.h>
#		else
#			ifdef _AIX
				/*
				 * Indent so pre-ANSI compilers will ignore it
				 *
				 * Some versions of AIX may require this to be
				 * first in the file and only preceded by
				 * comments and preprocessor directives/
				 */
				#pragma alloca
#			else
#				ifndef alloca
					/*
					 * predefined by HP cc +Olibcalls
					 */
#					ifdef	PROTOTYPES
						extern void *alloca();
#					else
						extern char *alloca();
#					endif
#				endif
#			endif
#		endif
#	endif
#endif


#endif	/* _ALLOCAX_H */
