/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager2;
import swingwtx.swing.SizeRequirements;

public class BoxLayout
implements LayoutManager2 {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    protected SizeRequirements[] childWidth;
    protected SizeRequirements[] childHeight;
    protected SizeRequirements totalWidth;
    protected SizeRequirements totalHeight;
    private int axis;
    private Component target = null;

    public BoxLayout(Component target, int axis) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new Error("Invalid axis");
        }
        this.axis = axis;
        this.target = target;
    }

    public BoxLayout(Container target, int axis) {
        this((Component)target, axis);
    }

    public synchronized void invalidateLayout(Container target) {
        this.childWidth = null;
        this.childHeight = null;
        this.totalWidth = null;
        this.totalHeight = null;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public Dimension preferredLayoutSize(Container target) {
        this.calculate();
        Dimension size = null;
        size = this.totalWidth == null ? new Dimension(0, 0) : new Dimension(this.totalWidth.preferred, this.totalHeight.preferred);
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    public Dimension minimumLayoutSize(Container target) {
        this.calculate();
        Dimension size = new Dimension(this.totalWidth.minimum, this.totalHeight.minimum);
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    public Dimension maximumLayoutSize(Container target) {
        this.calculate();
        Dimension size = new Dimension(this.totalWidth.maximum, this.totalHeight.maximum);
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    public synchronized float getLayoutAlignmentX(Container target) {
        this.calculate();
        return this.totalWidth.alignment;
    }

    public synchronized float getLayoutAlignmentY(Container target) {
        this.calculate();
        return this.totalHeight.alignment;
    }

    public void layoutContainer(Container target) {
        int nChildren = target.getComponentCount();
        int[] xOffsets = new int[nChildren];
        int[] xSpans = new int[nChildren];
        int[] yOffsets = new int[nChildren];
        int[] ySpans = new int[nChildren];
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        int absoluteAxis = 0;
        absoluteAxis = this.axis == 2 ? (target.getComponentOrientation().isHorizontal() ? 0 : 1) : (this.axis == 3 ? (target.getComponentOrientation().isHorizontal() ? 1 : 0) : this.axis);
        boolean ltr = absoluteAxis != this.axis ? target.getComponentOrientation().isLeftToRight() : true;
        this.calculate();
        nChildren = this.childWidth.length;
        xOffsets = new int[nChildren];
        xSpans = new int[nChildren];
        yOffsets = new int[nChildren];
        ySpans = new int[nChildren];
        if (absoluteAxis == 0) {
            SizeRequirements.calculateAlignedPositions(alloc.height, this.totalHeight, this.childHeight, yOffsets, ySpans);
            SizeRequirements.calculateTiledPositions(alloc.width, this.totalWidth, this.childWidth, xOffsets, xSpans, ltr);
        } else {
            SizeRequirements.calculateTiledPositions(alloc.height, this.totalHeight, this.childHeight, yOffsets, ySpans);
            SizeRequirements.calculateAlignedPositions(alloc.width, this.totalWidth, this.childWidth, xOffsets, xSpans, ltr);
        }
        for (int i = 0; i < nChildren; ++i) {
            Component c = target.getComponent(i);
            c.setBounds((int)Math.min((long)in.left + (long)xOffsets[i], Integer.MAX_VALUE), (int)Math.min((long)in.top + (long)yOffsets[i], Integer.MAX_VALUE), xSpans[i], ySpans[i]);
        }
    }

    protected void calculate() {
        if (!(this.target instanceof Container)) {
            return;
        }
        Container tg = (Container)this.target;
        int n = tg.getComponentCount();
        this.childWidth = new SizeRequirements[n];
        this.childHeight = new SizeRequirements[n];
        for (int i = 0; i < n; ++i) {
            Component c = tg.getComponent(i);
            if (!c.isVisible()) {
                this.childWidth[i] = new SizeRequirements(0, 0, 0, c.getAlignmentX());
                this.childHeight[i] = new SizeRequirements(0, 0, 0, c.getAlignmentY());
                continue;
            }
            Dimension min = c.getMinimumSize();
            Dimension typ = c.getPreferredSize();
            Dimension max = c.getMaximumSize();
            this.childWidth[i] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
            this.childHeight[i] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
        }
        int absoluteAxis = 0;
        absoluteAxis = this.axis == 2 ? (tg.getComponentOrientation().isHorizontal() ? 0 : 1) : (this.axis == 3 ? (tg.getComponentOrientation().isHorizontal() ? 1 : 0) : this.axis);
        if (absoluteAxis == 0) {
            this.totalWidth = SizeRequirements.getTiledSizeRequirements(this.childWidth);
            this.totalHeight = SizeRequirements.getAlignedSizeRequirements(this.childHeight);
        } else {
            this.totalWidth = SizeRequirements.getAlignedSizeRequirements(this.childWidth);
            this.totalHeight = SizeRequirements.getTiledSizeRequirements(this.childHeight);
        }
    }
}

