/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelp;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.help.AbstractHelpUI;
import org.eclipse.ui.help.IContextComputer;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkbenchHelp {
    private static final String HELP_KEY = "org.eclipse.ui.help";
    private static final String HELP_SYSTEM_EXTENSION_ID = "org.eclipse.ui.helpSupport";
    private static final String HELP_SYSTEM_CLASS_ATTRIBUTE = "class";
    private static AbstractHelpUI pluggableHelpUI = null;
    private static IHelp helpCompatibilityWrapper = null;
    private static boolean isInitialized = false;
    private static HelpListener helpListener = null;

    private WorkbenchHelp() {
    }

    public static void displayHelp() {
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        if (helpUI != null) {
            helpUI.displayHelp();
        }
    }

    public static void displayContext(IContext context, int x, int y) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        if (helpUI != null) {
            helpUI.displayContext(context, x, y);
        }
    }

    public static void displayHelpResource(String href) {
        if (href == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        if (helpUI != null) {
            helpUI.displayHelpResource(href);
        }
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    public static HelpListener createHelpListener(ICommand command) {
        return new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (WorkbenchHelp.getHelpUI() != null) {
                    IContext context = HelpSystem.getContext((String)"");
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayContext(context, point.x, point.y);
                }
            }
        };
    }

    public static void displayHelp(String contextId) {
        IContext context = HelpSystem.getContext((String)contextId);
        Point point = WorkbenchHelp.computePopUpLocation(Display.getCurrent());
        WorkbenchHelp.displayContext(context, point.x, point.y);
    }

    public static void displayHelp(IContext context) {
        Point point = WorkbenchHelp.computePopUpLocation(Display.getCurrent());
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        if (helpUI != null) {
            helpUI.displayContext(context, point.x, point.y);
        }
    }

    public static Object getHelp(Control control) {
        return control.getData(HELP_KEY);
    }

    public static Object getHelp(Menu menu) {
        return menu.getData(HELP_KEY);
    }

    public static Object getHelp(MenuItem menuItem) {
        return menuItem.getData(HELP_KEY);
    }

    private static HelpListener getHelpListener() {
        if (helpListener == null) {
            WorkbenchHelp.initializeHelpListener();
        }
        return helpListener;
    }

    private static void initializeHelpListener() {
        helpListener = new HelpListener(){

            public void helpRequested(HelpEvent event) {
                Object[] helpContexts;
                if (WorkbenchHelp.getHelpUI() == null) {
                    return;
                }
                Object object = event.widget.getData(WorkbenchHelp.HELP_KEY);
                IContext context = null;
                if (object instanceof String) {
                    context = HelpSystem.getContext((String)((String)object));
                } else if (object instanceof IContext) {
                    context = (IContext)object;
                } else if (object instanceof IContextComputer) {
                    helpContexts = ((IContextComputer)object).computeContexts(event);
                    if (helpContexts != null && helpContexts.length > 0) {
                        Object primaryEntry = helpContexts[0];
                        if (primaryEntry instanceof String) {
                            context = HelpSystem.getContext((String)((String)primaryEntry));
                        } else if (primaryEntry instanceof IContext) {
                            context = (IContext)primaryEntry;
                        }
                    }
                } else if (object instanceof Object[] && (helpContexts = (Object[])object).length > 0) {
                    Object primaryEntry = helpContexts[0];
                    if (primaryEntry instanceof String) {
                        context = HelpSystem.getContext((String)((String)primaryEntry));
                    } else if (primaryEntry instanceof IContext) {
                        context = (IContext)primaryEntry;
                    }
                }
                if (context != null) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayContext(context, point.x, point.y);
                }
            }
        };
    }

    public static IHelp getHelpSupport() {
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        if (helpUI != null && helpCompatibilityWrapper == null) {
            helpCompatibilityWrapper = new CompatibilityIHelpImplementation();
        }
        return helpCompatibilityWrapper;
    }

    private static AbstractHelpUI getHelpUI() {
        if (!isInitialized) {
            WorkbenchHelp.initializePluggableHelpUI();
            isInitialized = true;
        }
        return pluggableHelpUI;
    }

    private static void initializePluggableHelpUI() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(WorkbenchHelp.HELP_SYSTEM_EXTENSION_ID);
                if (point == null) {
                    return;
                }
                IExtension[] extensions = point.getExtensions();
                if (extensions.length == 0) {
                    return;
                }
                IConfigurationElement[] elements = extensions[0].getConfigurationElements();
                if (elements.length == 0) {
                    return;
                }
                try {
                    pluggableHelpUI = (AbstractHelpUI)WorkbenchPlugin.createExtension(elements[0], WorkbenchHelp.HELP_SYSTEM_CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to instantiate help UI" + e.getStatus());
                }
            }
        });
    }

    public static boolean isContextHelpDisplayed() {
        if (!isInitialized) {
            return false;
        }
        AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
        return helpUI != null && helpUI.isContextHelpDisplayed();
    }

    public static void setHelp(IAction action, final Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (contexts != null && contexts.length > 0 && WorkbenchHelp.getHelpUI() != null) {
                    IContext context = null;
                    if (contexts[0] instanceof String) {
                        context = HelpSystem.getContext((String)((String)contexts[0]));
                    } else if (contexts[0] instanceof IContext) {
                        context = (IContext)contexts[0];
                    }
                    if (context != null) {
                        Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                        WorkbenchHelp.displayContext(context, point.x, point.y);
                    }
                }
            }
        });
    }

    public static void setHelp(IAction action, final IContextComputer computer) {
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                Object[] helpContexts = computer.computeContexts(event);
                if (helpContexts != null && helpContexts.length > 0 && WorkbenchHelp.getHelpUI() != null) {
                    IContext context = null;
                    if (helpContexts[0] instanceof String) {
                        context = HelpSystem.getContext((String)((String)helpContexts[0]));
                    } else if (helpContexts[0] instanceof IContext) {
                        context = (IContext)helpContexts[0];
                    }
                    if (context != null) {
                        Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                        WorkbenchHelp.displayContext(context, point.x, point.y);
                    }
                }
            }
        });
    }

    public static void setHelp(Control control, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        control.setData(HELP_KEY, (Object)contexts);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Control control, IContextComputer computer) {
        control.setData(HELP_KEY, (Object)computer);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        menu.setData(HELP_KEY, (Object)contexts);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, IContextComputer computer) {
        menu.setData(HELP_KEY, (Object)computer);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        item.setData(HELP_KEY, (Object)contexts);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, IContextComputer computer) {
        item.setData(HELP_KEY, (Object)computer);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(IAction action, final String contextId) {
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (WorkbenchHelp.getHelpUI() != null) {
                    IContext context = HelpSystem.getContext((String)contextId);
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayContext(context, point.x, point.y);
                }
            }
        });
    }

    public static void setHelp(Control control, String contextId) {
        control.setData(HELP_KEY, (Object)contextId);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, String contextId) {
        menu.setData(HELP_KEY, (Object)contextId);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, String contextId) {
        item.setData(HELP_KEY, (Object)contextId);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    private static class CompatibilityIHelpImplementation
    implements IHelp {
        CompatibilityIHelpImplementation() {
        }

        public void displayHelp() {
            AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
            if (helpUI != null) {
                helpUI.displayHelp();
            }
        }

        public void displayContext(IContext context, int x, int y) {
            AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
            if (helpUI != null) {
                helpUI.displayContext(context, x, y);
            }
        }

        public void displayContext(String contextId, int x, int y) {
            this.displayContext(HelpSystem.getContext((String)contextId), x, y);
        }

        public void displayHelpResource(String href) {
            AbstractHelpUI helpUI = WorkbenchHelp.getHelpUI();
            if (helpUI != null) {
                helpUI.displayHelpResource(href);
            }
        }

        public void displayHelpResource(IHelpResource helpResource) {
            this.displayHelpResource(helpResource.getHref());
        }

        public void displayHelp(String toc) {
            this.displayHelpResource(toc);
        }

        public void displayHelp(String toc, String selectedTopic) {
            this.displayHelpResource(selectedTopic);
        }

        public void displayHelp(String contextId, int x, int y) {
            this.displayContext(contextId, x, y);
        }

        public void displayHelp(IContext context, int x, int y) {
            this.displayContext(context, x, y);
        }

        public IContext getContext(String contextId) {
            return HelpSystem.getContext((String)contextId);
        }

        public IToc[] getTocs() {
            return HelpSystem.getTocs();
        }

        public boolean isContextHelpDisplayed() {
            return WorkbenchHelp.isContextHelpDisplayed();
        }
    }
}

