/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.ContextManagerFactory;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IMutableContextManager;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.ProxyContextManager;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;

public class WorkbenchContextSupport
implements IWorkbenchContextSupport {
    private static final boolean DEBUG = Policy.DEBUG_CONTEXTS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_CONTEXTS_VERBOSE;
    private static final int DEBUG_STACK_LENGTH_TO_SHOW = 5;
    private Listener activationListener = new Listener(){

        public void handleEvent(Event event) {
            WorkbenchContextSupport.this.checkWindowType(event.display.getActiveShell());
        }
    };
    private Shell activeShell;
    private IWorkbenchSite activeWorkbenchSite;
    private IWorkbenchWindow activeWorkbenchWindow;
    private Map enabledSubmissionsByContextId = new HashMap();
    private final WorkbenchKeyboard keyboard;
    private volatile boolean keyFilterEnabled;
    private IMutableContextManager mutableContextManager;
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private ProxyContextManager proxyContextManager;
    private final Map registeredWindows = new WeakHashMap();
    private Workbench workbench;
    static /* synthetic */ Class class$0;

    public WorkbenchContextSupport(Workbench workbenchToSupport) {
        this.workbench = workbenchToSupport;
        this.mutableContextManager = ContextManagerFactory.getMutableContextManager();
        this.proxyContextManager = new ProxyContextManager(this.mutableContextManager);
        this.keyboard = new WorkbenchKeyboard(this.workbench, this.workbench.getActivitySupport().getActivityManager(), this.workbench.getCommandSupport().getCommandManager());
        this.setKeyFilterEnabled(true);
        workbenchToSupport.getDisplay().addFilter(26, this.activationListener);
    }

    public void addEnabledSubmissions(List enabledSubmissions) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.EnabledSubmission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledSubmissions = Util.safeCopy(enabledSubmissions, (Class)clazz);
        Iterator iterator = enabledSubmissions.iterator();
        while (iterator.hasNext()) {
            EnabledSubmission enabledSubmission = (EnabledSubmission)iterator.next();
            String contextId = enabledSubmission.getContextId();
            ArrayList<EnabledSubmission> enabledSubmissions2 = (ArrayList<EnabledSubmission>)this.enabledSubmissionsByContextId.get(contextId);
            if (enabledSubmissions2 == null) {
                enabledSubmissions2 = new ArrayList<EnabledSubmission>();
                this.enabledSubmissionsByContextId.put(contextId, enabledSubmissions2);
            }
            enabledSubmissions2.add(enabledSubmission);
        }
        this.processEnabledSubmissions(true);
    }

    private final void checkWindowType(Shell newShell) {
        boolean submissionsProcessed = false;
        Shell oldShell = this.activeShell;
        List oldSubmissions = (List)this.registeredWindows.get(oldShell);
        if (oldSubmissions == null && (oldSubmissions = (List)this.registeredWindows.get(null)) != null) {
            this.removeEnabledSubmissions(oldSubmissions);
            submissionsProcessed = true;
        }
        if (newShell != null && !newShell.isDisposed() && newShell.getParent() != null) {
            ArrayList<EnabledSubmission> newSubmissions = new ArrayList<EnabledSubmission>();
            newSubmissions.add(new EnabledSubmission(newShell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
            newSubmissions.add(new EnabledSubmission(newShell, null, "org.eclipse.ui.contexts.dialog"));
            this.addEnabledSubmissions(newSubmissions);
            this.registeredWindows.put(newShell, newSubmissions);
            submissionsProcessed = true;
        }
        if (!submissionsProcessed) {
            this.processEnabledSubmissions(false, newShell);
        }
    }

    public IContextManager getContextManager() {
        return this.proxyContextManager;
    }

    public final WorkbenchKeyboard getKeyboard() {
        return this.keyboard;
    }

    public boolean isKeyFilterEnabled() {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            return this.keyFilterEnabled;
        }
    }

    private void processEnabledSubmissions(boolean force) {
        this.processEnabledSubmissions(force, this.workbench.getDisplay().getActiveShell());
    }

    public void processEnabledSubmissions(boolean force, Shell newActiveShell) {
        IWorkbenchPart activeWorkbenchPart;
        IWorkbenchPage activeWorkbenchPage;
        IWorkbenchPartSite newActiveWorkbenchSite = null;
        IWorkbenchWindow newActiveWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        boolean update = false;
        if (this.activeShell != newActiveShell) {
            this.activeShell = newActiveShell;
            update = true;
        }
        if (this.activeWorkbenchWindow != newActiveWorkbenchWindow) {
            if (this.activeWorkbenchWindow != null) {
                this.activeWorkbenchWindow.removePageListener(this.pageListener);
                this.activeWorkbenchWindow.removePerspectiveListener(this.perspectiveListener);
                this.activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
            }
            if (newActiveWorkbenchWindow != null) {
                newActiveWorkbenchWindow.addPageListener(this.pageListener);
                newActiveWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
                newActiveWorkbenchWindow.getPartService().addPartListener(this.partListener);
            }
            this.activeWorkbenchWindow = newActiveWorkbenchWindow;
            update = true;
        }
        if (newActiveWorkbenchWindow != null && (activeWorkbenchPage = newActiveWorkbenchWindow.getActivePage()) != null && (activeWorkbenchPart = activeWorkbenchPage.getActivePart()) != null) {
            newActiveWorkbenchSite = activeWorkbenchPart.getSite();
        }
        if (force || update || !Util.equals(this.activeWorkbenchSite, newActiveWorkbenchSite)) {
            HashSet<String> enabledContextIds;
            block21: {
                String contextId;
                this.activeWorkbenchSite = newActiveWorkbenchSite;
                enabledContextIds = new HashSet<String>();
                Iterator iterator = this.enabledSubmissionsByContextId.entrySet().iterator();
                block2: while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String contextId2 = (String)entry.getKey();
                    List enabledSubmissions = (List)entry.getValue();
                    int i = 0;
                    while (i < enabledSubmissions.size()) {
                        IWorkbenchSite activeWorkbenchSite2;
                        EnabledSubmission enabledSubmission = (EnabledSubmission)enabledSubmissions.get(i);
                        Shell activeShell2 = enabledSubmission.getActiveShell();
                        if (!(activeShell2 != null && activeShell2 != newActiveShell || (activeWorkbenchSite2 = enabledSubmission.getActiveWorkbenchSite()) != null && activeWorkbenchSite2 != newActiveWorkbenchSite)) {
                            enabledContextIds.add(contextId2);
                            continue block2;
                        }
                        ++i;
                    }
                }
                Iterator contextIdItr = enabledContextIds.iterator();
                boolean dialog = false;
                boolean window = false;
                while (contextIdItr.hasNext()) {
                    contextId = (String)contextIdItr.next();
                    if ("org.eclipse.ui.contexts.dialog".equals(contextId)) {
                        dialog = true;
                        continue;
                    }
                    if (!"org.eclipse.ui.contexts.window".equals(contextId)) continue;
                    window = true;
                }
                try {
                    contextIdItr = enabledContextIds.iterator();
                    block5: while (contextIdItr.hasNext()) {
                        contextId = (String)contextIdItr.next();
                        IContext context = this.mutableContextManager.getContext(contextId);
                        String parentId = context.getParentId();
                        while (parentId != null) {
                            if ("org.eclipse.ui.contexts.dialog".equals(parentId)) {
                                if (dialog) continue block5;
                                contextIdItr.remove();
                                continue block5;
                            }
                            if ("org.eclipse.ui.contexts.window".equals(parentId)) {
                                if (window) continue block5;
                                contextIdItr.remove();
                                continue block5;
                            }
                            if ("org.eclipse.ui.contexts.dialogAndWindow".equals(parentId)) {
                                if (window || dialog) continue block5;
                                contextIdItr.remove();
                                continue block5;
                            }
                            context = this.mutableContextManager.getContext(parentId);
                            parentId = context.getParentId();
                        }
                    }
                }
                catch (NotDefinedException e) {
                    if (!DEBUG) break block21;
                    System.out.println("CONTEXTS >>> NotDefinedException('" + e.getMessage() + "') while filtering dialog/window contexts`");
                }
            }
            if (DEBUG && !this.mutableContextManager.getEnabledContextIds().equals(enabledContextIds)) {
                System.out.println("CONTEXTS >>> " + enabledContextIds);
                if (DEBUG_VERBOSE) {
                    Exception exception = new Exception();
                    exception.fillInStackTrace();
                    StackTraceElement[] stackTrace = exception.getStackTrace();
                    int elementsToShow = stackTrace.length < 5 ? stackTrace.length : 5;
                    int i = 0;
                    while (i < elementsToShow) {
                        StackTraceElement element = stackTrace[i];
                        System.out.println("CONTEXTS >>>     " + element.toString());
                        ++i;
                    }
                }
            }
            this.mutableContextManager.setEnabledContextIds(enabledContextIds);
        }
    }

    public boolean registerShell(final Shell shell, int type) throws IllegalArgumentException, NullPointerException {
        if (shell == null) {
            throw new NullPointerException("The shell was null");
        }
        final ArrayList<EnabledSubmission> submissions = new ArrayList<EnabledSubmission>();
        switch (type) {
            case 0: {
                submissions.add(new EnabledSubmission(shell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
                submissions.add(new EnabledSubmission(shell, null, "org.eclipse.ui.contexts.dialog"));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                submissions.add(new EnabledSubmission(shell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
                submissions.add(new EnabledSubmission(shell, null, "org.eclipse.ui.contexts.window"));
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not recognized: " + type);
            }
        }
        boolean returnValue = false;
        List previousSubmissions = (List)this.registeredWindows.get(shell);
        if (previousSubmissions != null) {
            returnValue = true;
            this.removeEnabledSubmissions(previousSubmissions);
        }
        this.registeredWindows.put(shell, submissions);
        this.addEnabledSubmissions(submissions);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbenchContextSupport.this.registeredWindows.remove(shell);
                WorkbenchContextSupport.this.removeEnabledSubmissions(submissions);
            }
        });
        return returnValue;
    }

    public void removeEnabledSubmissions(List enabledSubmissions) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.EnabledSubmission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledSubmissions = Util.safeCopy(enabledSubmissions, (Class)clazz);
        Iterator iterator = enabledSubmissions.iterator();
        while (iterator.hasNext()) {
            EnabledSubmission enabledSubmission = (EnabledSubmission)iterator.next();
            String contextId = enabledSubmission.getContextId();
            List enabledSubmissions2 = (List)this.enabledSubmissionsByContextId.get(contextId);
            if (enabledSubmissions2 == null) continue;
            enabledSubmissions2.remove(enabledSubmission);
            if (!enabledSubmissions2.isEmpty()) continue;
            this.enabledSubmissionsByContextId.remove(contextId);
        }
        this.processEnabledSubmissions(true);
    }

    public void setKeyFilterEnabled(boolean enabled) {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            Display currentDisplay = Display.getCurrent();
            Listener keyFilter = this.keyboard.getKeyDownFilter();
            if (enabled) {
                currentDisplay.addFilter(1, keyFilter);
                currentDisplay.addFilter(31, keyFilter);
            } else {
                currentDisplay.removeFilter(1, keyFilter);
                currentDisplay.removeFilter(31, keyFilter);
            }
            this.keyFilterEnabled = enabled;
        }
    }

    public boolean unregisterShell(Shell shell) {
        if (shell == null) {
            return false;
        }
        List previousSubmissions = (List)this.registeredWindows.get(shell);
        if (previousSubmissions != null) {
            this.registeredWindows.remove(shell);
            this.removeEnabledSubmissions(previousSubmissions);
            return true;
        }
        return false;
    }
}

