/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.IconAnimationItem;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;

class ImageAnimationProcessor
implements IAnimationProcessor {
    private static final String RUNNING_ICON = "running.gif";
    private static final String BACKGROUND_ICON = "back.gif";
    private ImageData[] animatedData;
    private ImageData[] disabledData;
    private AnimationManager manager;
    private static String DISABLED_IMAGE_NAME = "ANIMATION_DISABLED_IMAGE";
    private static String ANIMATED_IMAGE_NAME = "ANIMATION_ANIMATED_IMAGE";
    private ImageLoader runLoader = new ImageLoader();
    Color background;
    Job animateJob;
    Job clearJob;
    List items = Collections.synchronizedList(new ArrayList());

    ImageAnimationProcessor(AnimationManager animationManager) {
        this.manager = animationManager;
        URL iconsRoot = Platform.getPlugin((String)"org.eclipse.ui").find((IPath)new Path("icons/full/progress/"));
        ProgressManager progressManager = ProgressManager.getInstance();
        try {
            URL runningRoot = new URL(iconsRoot, RUNNING_ICON);
            URL backRoot = new URL(iconsRoot, BACKGROUND_ICON);
            this.animatedData = progressManager.getImageData(runningRoot, this.runLoader);
            if (this.animatedData != null) {
                JFaceResources.getImageRegistry().put(ANIMATED_IMAGE_NAME, progressManager.getImage(this.animatedData[0]));
            }
            this.disabledData = progressManager.getImageData(backRoot, this.runLoader);
            if (this.disabledData != null) {
                JFaceResources.getImageRegistry().put(DISABLED_IMAGE_NAME, progressManager.getImage(this.disabledData[0]));
            }
        }
        catch (MalformedURLException exception) {
            ProgressManagerUtil.logException(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void animateLoop(IProgressMonitor monitor) {
        if (this.items.size() == 0) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        animationItems = this.getAnimationItems();
        display = PlatformUI.getWorkbench().getDisplay();
        imageDataArray = this.getImageData();
        imageData = imageDataArray[0];
        image = ProgressManager.getInstance().getImage(imageData);
        imageDataIndex = 0;
        loader = this.getLoader();
        if (display.isDisposed()) {
            monitor.setCanceled(true);
            this.manager.setAnimated(false);
            return;
        }
        offScreenImage = new Image((Device)display, loader.logicalScreenWidth, loader.logicalScreenHeight);
        offScreenImageGC = new GC((Drawable)offScreenImage);
        try {
            offScreenImageGC.setBackground(this.background);
            offScreenImageGC.fillRectangle(0, 0, loader.logicalScreenWidth, loader.logicalScreenHeight);
            offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
            if (loader.repeatCount > 0) {
                while (this.manager.isAnimated() && !monitor.isCanceled()) {
                    block23: {
                        if (display.isDisposed()) {
                            monitor.setCanceled(true);
                            continue;
                        }
                        if (imageData.disposalMethod == 2) {
                            bgColor = null;
                            backgroundPixel = loader.backgroundPixel;
                            if (backgroundPixel != -1) {
                                backgroundRGB = imageData.palette.getRGB(backgroundPixel);
                                bgColor = new Color(null, backgroundRGB);
                            }
                            try {
                                offScreenImageGC.setBackground(bgColor != null ? bgColor : this.background);
                                offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                            }
                            catch (Throwable var14_15) {
                                backgroundRGB = null;
                                if (bgColor == null) throw var14_15;
                                bgColor.dispose();
                                throw var14_15;
                            }
                            {
                                backgroundRGB = null;
                                if (bgColor != null) {
                                    bgColor.dispose();
                                }
                                break block23;
                            }
                        }
                        if (imageData.disposalMethod == 3) {
                            offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        }
                    }
                    imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
                    imageData = imageDataArray[imageDataIndex];
                    image.dispose();
                    image = new Image((Device)display, imageData);
                    offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                    refreshItems = false;
                    i = 0;
                    while (true) {
                        if (i >= animationItems.length) {
                            if (refreshItems) {
                                animationItems = this.getAnimationItems();
                            }
                            ** try [egrp 3[TRYBLOCK] [2 : 521->540)] { 
lbl62:
                            // 1 sources

                            break;
                        }
                        item = animationItems[i];
                        if (item.imageCanvasGC.isDisposed()) {
                            refreshItems = true;
                        } else {
                            item.imageCanvasGC.drawImage(offScreenImage, 0, 0);
                        }
                        ++i;
                    }
                    {
                        Thread.sleep(this.visibleDelay(imageData.delayTime * 10));
                        continue;
                    }
lbl72:
                    // 1 sources

                    catch (InterruptedException v0) {}
                }
            }
        }
        catch (Throwable var16_16) {
            var15_17 = null;
            image.dispose();
            offScreenImage.dispose();
            offScreenImageGC.dispose();
            throw var16_16;
        }
        {
            var15_18 = null;
        }
        image.dispose();
        offScreenImage.dispose();
        offScreenImageGC.dispose();
    }

    public void animationFinished() {
        IconAnimationItem[] animationItems = this.getAnimationItems();
        int i = 0;
        while (i < animationItems.length) {
            IconAnimationItem item = animationItems[i];
            item.animationDone();
            ++i;
        }
    }

    ImageLoader getLoader() {
        return this.runLoader;
    }

    ImageData[] getImageData() {
        if (this.manager.isAnimated()) {
            return this.animatedData;
        }
        return this.disabledData;
    }

    Image getImage() {
        if (this.manager.isAnimated()) {
            return JFaceResources.getImageRegistry().get(ANIMATED_IMAGE_NAME);
        }
        return JFaceResources.getImageRegistry().get(DISABLED_IMAGE_NAME);
    }

    public Rectangle getImageBounds() {
        return JFaceResources.getImageRegistry().get(DISABLED_IMAGE_NAME).getBounds();
    }

    int visibleDelay(int ms) {
        if (ms < 20) {
            return ms + 30;
        }
        if (ms < 30) {
            return ms + 10;
        }
        return ms;
    }

    private IconAnimationItem[] getAnimationItems() {
        IconAnimationItem[] animationItems = new IconAnimationItem[this.items.size()];
        this.items.toArray(animationItems);
        return animationItems;
    }

    public void addItem(final AnimationItem item) {
        Assert.isTrue(item instanceof IconAnimationItem);
        this.items.add(item);
        if (this.background == null) {
            this.background = AnimationManager.getItemBackgroundColor(item.getControl());
        }
        item.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageAnimationProcessor.this.items.remove(item);
            }
        });
    }

    public void animationStarted() {
        IconAnimationItem[] animationItems = this.getAnimationItems();
        int i = 0;
        while (i < animationItems.length) {
            animationItems[i].animationStart();
            ++i;
        }
        this.getAnimateJob().schedule();
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public void itemsInactiveRedraw() {
        IconAnimationItem[] animationItems = this.getAnimationItems();
        int i = 0;
        while (i < animationItems.length) {
            animationItems[i].getControl().redraw();
            ++i;
        }
    }

    public int getPreferredWidth() {
        if (this.animatedData == null) {
            return 0;
        }
        return this.animatedData[0].width;
    }

    private Job getAnimateJob() {
        if (this.animateJob == null) {
            this.animateJob = new Job(ProgressMessages.getString("AnimateJob.JobName")){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        ImageAnimationProcessor.this.animateLoop(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (SWTException exception) {
                        return ProgressManagerUtil.exceptionStatus(exception);
                    }
                }

                public boolean shouldSchedule() {
                    return PlatformUI.isWorkbenchRunning();
                }

                public boolean shouldRun() {
                    return PlatformUI.isWorkbenchRunning();
                }
            };
            this.animateJob.setSystem(true);
            this.animateJob.setPriority(50);
            this.animateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (ImageAnimationProcessor.this.manager.isAnimated() && ImageAnimationProcessor.this.hasItems()) {
                        ImageAnimationProcessor.this.animateJob.schedule();
                    } else {
                        if (ImageAnimationProcessor.this.clearJob == null) {
                            ImageAnimationProcessor.this.createClearJob();
                        }
                        ImageAnimationProcessor.this.clearJob.schedule();
                    }
                }
            });
        }
        return this.animateJob;
    }

    void createClearJob() {
        this.clearJob = new UIJob(ProgressMessages.getString("AnimationItem.RedrawJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ImageAnimationProcessor.this.itemsInactiveRedraw();
                return Status.OK_STATUS;
            }
        };
        this.clearJob.setSystem(true);
        this.clearJob.setPriority(50);
    }

    public boolean isProcessorJob(Job job) {
        return job == this.clearJob || job == this.animateJob;
    }
}

