/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.AssociatedWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewer;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

class ProgressFloatingWindow
extends AssociatedWindow {
    ProgressViewer viewer;
    WorkbenchWindow window;
    final int borderSize = 1;

    ProgressFloatingWindow(WorkbenchWindow workbenchWindow, Control associatedControl) {
        super(workbenchWindow.getShell(), associatedControl, 2);
        this.window = workbenchWindow;
        if ("carbon".equals(SWT.getPlatform())) {
            this.setShellStyle(16392);
        } else {
            this.setShellStyle(8);
        }
    }

    protected Layout getLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        return layout;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setLayout(this.getLayout());
        this.setBackground((Control)newShell);
        this.addRoundBorder(newShell, 1);
        newShell.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ProgressFloatingWindow.this.window.closeFloatingWindow();
            }
        });
    }

    protected Control createContents(Composite root) {
        this.viewer = new ProgressViewer(root, 524288, 5, 72){

            protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
                super.doUpdateItem(widget, element, fullMap);
                ProgressFloatingWindow.this.moveShell(ProgressFloatingWindow.this.getShell(), 1);
            }
        };
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        Control control = this.viewer.getControl();
        this.setBackground(control);
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0);
        tableData.right = new FormAttachment(100);
        tableData.top = new FormAttachment(0);
        tableData.bottom = new FormAttachment(100);
        Point preferredSize = this.viewer.getSizeHints();
        tableData.width = preferredSize.x;
        tableData.height = preferredSize.y;
        this.viewer.getControl().setLayoutData((Object)tableData);
        this.initContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.viewerLabelProvider());
        root.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ProgressFloatingWindow.this.window.closeFloatingWindow();
            }
        });
        return this.viewer.getControl();
    }

    private LabelProvider viewerLabelProvider() {
        return new ProgressViewerLabelProvider(this.viewer.getControl());
    }

    protected void initContentProvider() {
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.constrainShellSize();
        this.getShell().setVisible(true);
        this.moveShell(this.getShell(), 1);
        return this.getReturnCode();
    }

    private void setBackground(Control control) {
        control.setBackground(control.getDisplay().getSystemColor(29));
    }
}

