/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class ProgressViewerLabelProvider
extends LabelProvider {
    private Control control;
    private String ellipsis = ProgressMessages.getString("ProgressFloatingWindow.EllipsisValue");

    public String getText(Object element) {
        JobTreeElement info = (JobTreeElement)element;
        return this.shortenText(info.getCondensedDisplayString());
    }

    protected String shortenText(String textValue) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        Display display = this.control.getDisplay();
        GC gc = new GC((Drawable)display);
        int maxWidth = this.control.getBounds().width - 5;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)this.ellipsis).x;
        int start = pivot = length / 2;
        int end = pivot + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 < maxWidth) {
                gc.dispose();
                return String.valueOf(s1) + this.ellipsis + s2;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }

    public ProgressViewerLabelProvider(Control progressControl) {
        this.control = progressControl;
    }
}

