/* Cache Element */
typedef struct s_cache_elem  *CACHE_ELEM;
struct s_cache_elem {
  void        *object;          /* cached object */
  void        *key;             /* element key */
  int         key_len;          /* key length */
  CACHE_ELEM  l_forw, l_back;   /* forward/backward in LRU list */
  CACHE_ELEM  h_forw, h_back;   /* forward/backward in hash table, free list*/
};


/* Cache */
typedef struct s_cache  *CACHE;
struct s_cache {
  /* Public: common method */
  void    *(*get)(CACHE,void*,int); 
  /* Private: class dependent method */
  void    *(*load_elem)(CACHE,void*,int);
  void    (*flush_elem)(void*);
  /* Private: data */
  int                  cache_size;
  int                  hash_size; 
  CACHE_ELEM           hash_table;
  struct s_cache_elem  lru_list;
  CACHE_ELEM           free_list;
  CACHE_ELEM           elem_tbl;
};

extern CACHE dvi_cache_create(int,int,
			      void *(*load_func)(CACHE,void*,int),
			      void (*flush_func)(void*));
extern void  dvi_cache_delete(CACHE);

/*EOF*/
