/*
 * spc_grf.h - embedded PostScript code analizer 
 *             for graphic{s,x}.sty package.
 * by Hirotsugu Kakugawa
 *
 */
/*
 * Copyright (C) 1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This file is part of the DVIlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DVILIB_SPC_GRF_H__
#define __DVILIB_SPC_GRF_H__

#define PS_CODE_TYPE_UNKNOWN        0
#define PS_CODE_TYPE_SCALE_BEGIN    1
#define PS_CODE_TYPE_SCALE_END      2
#define PS_CODE_TYPE_ROTATE_BEGIN   3
#define PS_CODE_TYPE_ROTATE_END     4
#define PS_CODE_PARAM  "***"


#define PS_CODE_MAX_PARAMS       16

extern int   dvi_ps_code_type(DVI,char*);
extern int   dvi_ps_gstate_get_current(DVI dvi,
				       double *p_scale_h, double *p_scale_v, 
				       int *p_angle);

extern int   dvi_gstate_stack_init(void);


extern void   dvi_ps_gstate_push(DVI dvi, int type, 
				 double scale_h, double scale_v, int angle);
extern void   dvi_ps_gstate_pop(DVI dvi, int expected_type,
				double *p_scale_h, double *p_scale_v, 
				int *p_angle);


#endif /*__DVILIB_SPC_GRF_H__*/
