# $Id: highlight.tcl,v 1.2 2003/12/28 21:40:25 aleksey Exp $

namespace eval highlight {
    custom::defgroup Highlight [::msgcat::mc "Groupchat message highlighting plugin options."] \
	-group Chat
    custom::defvar options(enable_highlighting) 0 \
	[::msgcat::mc "Enable highlighting plugin."] \
	-type boolean -group Highlight
    custom::defvar options(highlight_nick) 1 \
	[::msgcat::mc "Highlight current nickname in messages."] \
	-type boolean -group Highlight
    custom::defvar options(highlight_substrings) {} \
	[::msgcat::mc "Substrings to highlight in messages."] \
	-type string -group Highlight
    custom::defvar options(highlight_whole_words) 1 \
	[::msgcat::mc "Highlight only whole words in messages."] \
	-type boolean -group Highlight

    rename ::check_message ::check_message.orig
    proc ::check_message {nick body} \
	"return \[[namespace current]::check_message \$nick \$body\]"
}

proc highlight::check_message {nick body} {
    variable options

    if {!$options(enable_highlighting)} {
	return [::check_message.orig $nick $body]
    }

    set subs [split $options(highlight_substrings) " "]
    if {$options(highlight_nick)} {
	set subs [linsert $subs 0 $nick]
    }

    set ind_end 0
    set stop_ind [string length $body]
    set matches {}
    set found 1
    while {$found && $ind_end < $stop_ind} {
	set found 0
	set ind $ind_end
	foreach str $subs {
	    set len [string length $str]
	    if {$len > 0 && [set match [string first $str $body $ind]] >= 0} {
		if {!$options(highlight_whole_words) || \
			(![string is wordchar -strict [string index $body [expr {$match - 1}]]] && \
			![string is wordchar -strict [string index $body [expr {$match + $len}]]])} {
		    if {!$found} {
			set found 1
			set ind_start $match
			set ind_end [expr {$match + $len}]
		    } elseif {$match < $ind_start} {
			set ind_start $match
			set ind_end [expr {$match + $len}]
		    }
		}
	    }
	}
	if {$found} {
	    lappend matches $ind_start $ind_end
	}
    }
    return [list [expr {[llength $matches] > 0}] $matches]
}

