#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Mon Jan 19 14:24:08 2004
#

proc plCompare {A B} {
  set tA [string trim $A "<>="]
  set tB [string trim $B "<>="]

  return [string compare $tA $tB]
}

proc tkg_portListClear {} { 
  .sbar.portlst.f.l delete 0 end
}

proc tkg_portListAdd {p} {
  lbSortInsert .sbar.portlst.f.l $p plCompare
}

proc tkg_portListEnd {} {
}

proc tkg_makePortList {w} {
#  frame $w -relief groove -bd 2
#  frame $w.f
#  label $w.f.lab -text [m iports]

  labelframe $w [m iports]
  frame $w.pad
  pack $w.pad -pady 3

  frame $w.f


  listbox $w.f.l -width 15 -height 1 -yscrollcommand "$w.f.sb set" -takefocus 0
  scrollbar $w.f.sb -command "$w.f.l yview" -takefocus 0

#  pack $w.f.lab -anchor w
  pack $w.f.l $w.f.sb -side left -padx 1 -pady 1 -fill y
  pack $w.f -padx 2 -pady 4 -fill y -expand 1

#    helpon $w.f.lab [m ho.ports] 
  helpon ${w}_label [m ho.ports] 
}

tkg_makePortList .sbar.portlst
pack .sbar.portlst -fill both -expand 1 -padx 3 -pady 5
