/*
** iksemel (XML Parser for Jabber)
** Copyright (C) 2000-2001 Gurer Ozen <palpa@jabber.org>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
**
** utf8 - locale conversion
*/

#include "common.h"

#include <iconv.h>
#define IKSEMEL_ICONV 1

#include "iksemel.h"
#include <errno.h>

#define DEFAULT_CONV_POOL 4096
#define DEFAULT_CONV_BUFF 1024

iksconv *iks_conv_new(char *codeset)
{
	iksconv *conv;
        ikspool *p;
        
        p = iks_pool_new(DEFAULT_CONV_POOL);
        
        if (!p)
          return NULL;

	conv = iks_pool_alloc(p, sizeof(iksconv));
	if(!conv) return(NULL);

        conv->p = p;
        iks_pool_set_owner(p, conv);

	conv->buffer = iks_pool_alloc(conv->p, DEFAULT_CONV_BUFF);
	conv->len = DEFAULT_CONV_BUFF;
	conv->from = iconv_open("UTF-8", codeset);
	conv->to = iconv_open(codeset, "UTF-8");
	if(conv->buffer == NULL || conv->to == (iconv_t) -1 || conv->from == (iconv_t) -1)
	{
		iks_conv_delete(conv);
		return NULL;
	}
	return conv;
}


void iks_conv_delete(iksconv *conv)
{
	if(conv->to != (iconv_t) -1) iconv_close(conv->to);
	if(conv->from != (iconv_t) -1) iconv_close(conv->from);
	iks_pool_delete(conv->p);
}


static char *iks_conv_pika(iksconv *conv, const char *src, int len, int dir)
{
	char *in;
	char *out;
	size_t insize, outsize, ret;

	while(1)
	{
		in = (char*)src;
		out = conv->buffer;
		insize = len;
		outsize = conv->len;
		if(dir)
			iconv(conv->to, NULL, NULL, &out, &outsize);
		else
			iconv(conv->from, NULL, NULL, &out, &outsize);
		out = conv->buffer;
		if(dir)
			outsize = conv->len - sizeof(wchar_t);
		else
			outsize = conv->len - 1;

		if(dir)
			ret = iconv(conv->to, &in, &insize, &out, &outsize);
		else
			ret = iconv(conv->from, &in, &insize, &out, &outsize);

		if(ret == (size_t) -1)
		{
			if(errno == E2BIG)
			{
				conv->len += DEFAULT_CONV_BUFF;
				conv->buffer = iks_pool_realloc(conv->p, conv->buffer, conv->len);
                                if (!conv->buffer)
                                  return NULL;
			}
			else
			{
				return NULL;
			}
		}
		else
		{
			if(dir)
				*((wchar_t *)out) = L'\0';
			else
				*out = '\0';
			return conv->buffer;
		}
	}
}


char *iks_conv_locale(iksconv *conv, const char *src, int len)
{
	if(!src) return(NULL);
	return iks_conv_pika(conv, src, len, 1);
}


char *iks_conv_utf8(iksconv *conv, const char *src, int len)
{
	if(!src) return(NULL);
	return iks_conv_pika(conv, src, len, 0);
}
