#include "ttfprint.h"
#include <ctype.h>

#define PAPERS 16
#define USER	-1


/*Command defination */
#define PT	0	/* Paper Type */
#define PX	1	/* Pixel in X */
#define PY	2	/* Pixel in Y */
#define DNT	3	/* Document Name on Top of page */
#define DNB	4	/* Document Name on Bottom of page */
#define DNFS	5	/* Document Name Font Size */
#define DNCS	6	/* Document Name Char Space */
#define LM	7	/* Left Margin */
#define RM	8	/* Rigth Margin */
#define TM	9	/* Top Margin */
#define BM	10	/* Bottom Margin */
#define FS	11	/* Font Size */
#define CS	12	/* Char Space */
#define LS	13	/* Line Space */
#define FD	14	/* Font Dictionary */
#define WRAP	15	/* Wrap a line when longer then printable area */
#define FN	16	/* Font type Name */
#define CX	17	/* Char in X coordinate (char per line) */
#define CY	18	/* Char in Y coordinate (line per page) */
#define LAND	19	/* LANDscape printing */
#define DUP 	20	/* DUPlex printing */
#define MF	21	/* Manual Feed paper */
#define TRAY	22	/* select paper TRAY */
#define OUTBIN	23	/* printed paper OUTput BIN */
#define PGNO	24	/* print a footnote of PAge NO & date/time or not */ 
#define COPY	25	/* print more than 1 COPY */

#define HDR	26	/* print a Letter HeaDeR on first page */
#define MPHDR	27	/* print a letter header on every page */

#define TPL 	28	/* use TemPLate printing */
#define VPRINT	29	/* PRINT a Vertical text on specified area */
#define HPRINT	30	/* PRINT a Horizontal text on specified area */
#define BC39	31	/* print BarCode code 39 on specified area */
#define BC25	32	/* print BarCode code interleave 2 of 5 on specified area */
#define CODABAR 33	/* print barcode code CODABAR on specified area */

#define MPTPL	34	/* use MultiPage TemPLate printing */
#define MPVPRINT 35	/* PRINT a Vertical text on MPTPL printing */
#define MPHPRINT 36	/* PRINT a Horizontal text on MPTPL printing */
#define MPBC39	37	/* print BarCode code 39 on MPTPL printing */
#define MPBC25	38	/* print BarCode code interleave 2 of 5 on MPTPL printing */
#define MPCODABAR 39	/* print barcode code CODABAR on MPTPL printing */

#define FAX_NR	40	/* Fax numbers */
#define FAX_SPOOL 41	/* Deferred fax numbers */
#define EMAIL	42	/* result report E-mail */
#define NAME	43	/* name of current job */
#define FAX_ID	44	/* ID string on top of fax page */
#define COMMENT 45	/* comment */


#define TOTAL_CMD	46

static char command[][11]=
  {"pt","px","py","dnt","dnb","dnfs","dncs",
   "lm","rm","tm","bm","fs","cs","ls","fd",
   "wrap","fn","cx","cy","land","dup","mf",
   "tray","outbin","pgno","copy","hdr","mphdr","tpl",
   "vprint","hprint","bc39","bc25","codabar","mptpl","mpvprint",
   "mphprint","mpbc39","mpbc25","mpcodabar","fax-nr","fax-spool",
   "email","name","fax-id","comment"," "};
    
struct paper
  {
  char paper_type[10];
  int xcoor;
  int ycoor;
  };

extern void q_prog();  

extern PRECISION tm;        	/* top margin           */
extern PRECISION bm;        	/* bottom margin        */
extern PRECISION lm;        	/* left margin          */
extern PRECISION rm;        	/* right margin         */
extern PRECISION fs;      	/* font size            */
extern PRECISION cs;         	/* character space      */
extern PRECISION ls;         	/* line space           */
extern PRECISION dnfs;         	/* Doc Name font size   */
extern PRECISION dncs;         	/* Doc Name Char space  */
extern char dnb[];           	/* Doc Name at bottom   */
extern char dnt[];           	/* Doc Name at top      */
extern int pt;              	/* paper type           */
extern int px;                 	/* paper width (in dot) */
extern int py;                 	/* paper width (in dot) */
extern int cx;               	/* char per line        */
extern int cy;               	/* line per page        */
extern int dupp;		/* duplex printing */
extern int font_dict;       	/* number font dict     */
extern BOOL land;        	/* Landscape            */
extern BOOL wrap;         	/* wrap or not          */         
extern BOOL mf;			/* Manual Feed */
extern int tray;		/* Select Tray */
extern int outbin;		/* Select Output bin */
extern BOOL pgno;		/* Print Page no or not */
extern BOOL logdata;		/* Save log file or not */
extern int total_tplpage;	/* Total template pages */
extern int copy;		/* number of copies to print */
extern char hdr[];
extern char mphdr[];
extern struct fax_num *fax_nr;	/* Fax number list */
extern struct fax_num *fax_spool; /* Fax spool number list */
extern struct email  *email;	/* E-mail result report */
extern struct comment *comm;	/* Comment */
extern char name[];		/* Job name */
extern char fax_id[];		/* Fax id string */
extern struct err_cmd *err_cmd;	/* error command */

extern struct paper paper_array[];

extern int font_count;		/* Total different font */
extern long total_cchar;	
extern char font_sub_fn[];	/* ttf font file sub name */
void bubble();			/* bubble sort the font pool */
void tpl_command();		/* prase template printing command */

extern struct font_data *fl_head,*fl_tail,*fl_current;  
				/* font data structure's list */
extern struct tpl_pagedata *tpl_page[TPL_PAGE];
				/* template page spool */

extern char *psf_buffer;	/* font's postscript description buffer */
extern struct font_data fontpool[];
				
extern FILE *log_file;		/* log file's file descriptor */

/* variable for parse template print command */
char arg1[30];
char arg2[30];
char arg3[30];

char tempstr[MAXLINE+5]; 

void prescan(FILE *inf,FILE *tempfile)
  {
  int i,j,k;
  int tpl_pgno;
  unsigned char hbyte,lbyte;
  int char_count;
  char cmd[30],arg[30];
  struct fax_num *cur_faxnr;
  struct fax_num *last_faxnr=NULL;
  struct fax_num *cur_faxspool;
  struct fax_num *last_faxspool=NULL;
  struct email *cur_email=NULL;
  struct email *last_email=NULL;
  struct comment *cur_comm=NULL;
  struct comment *last_comm=NULL;
  struct err_cmd *cur_err=NULL;
  struct err_cmd *last_err=NULL;
  
  
  char *phone;
  
  font_count = 0;
  
  while (fgets(tempstr,MAXLINE,inf))
    {
    if (logdata == TRUE)
      fprintf(log_file,"%s",tempstr);
    char_count = 0;
    if ((tempstr[0] == '~') && (tempstr[1] =='!') && (tempstr[2]=='@'))
/* parse command line */
      {
      sscanf(&tempstr[3],"%s %s",cmd,arg);
          
      for (j = 0;j <= TOTAL_CMD + 2;j++)
        if (strcasecmp(cmd,command[j])==0)
          break;
      switch (j)
        {
        case PT		: for (k=0;k<PAPERS;k++)
            		    {
            		    if (!strcasecmp(arg,paper_array[k].paper_type))
            		      {
            		      pt = k;
            		      px = paper_array[k].xcoor;
            		      py = paper_array[k].ycoor;
            		      break;
			      }
			    }
            		  break;
            		    
        case PX		: pt = USER;
            		  px = atoi(arg);
            		  break;
        case PY		: pt = USER;
            		  py = atoi(arg);
            		  break;
        case DNT	: strcpy (dnt,arg);
            		  break;
        case DNB	: strcpy (dnb,arg);
            		  break;
        case DNFS	: dnfs = atof(arg);
            		  break;
        case DNCS	: dncs = atof(arg);
            		  break;
        case LM		: lm = atof(arg);
            		  break;
        case RM		: rm = atof(arg);
            		  break;
        case TM		: tm = atof(arg);
            		  break;
        case BM		: bm = atof(arg);
            		  break;
        case FS		: fs = atof(arg);
            	    	  break;
        case CS		: cs = atof(arg);
            	  	  break;
        case LS		: ls = atof(arg);
            	 	  break;
        case FD		: font_dict = atoi(arg);
            		  break;
        case WRAP	: if (!strcasecmp(arg,"true"))
            		    wrap=TRUE;
            		  else if (!strcasecmp(arg,"false"))
            		    wrap=FALSE;
            		  break; 
        case FN		: strcpy(font_sub_fn,arg);
            		  break;
        case CX		: cx = atoi(arg);
            		  break;
        case CY		: cy = atoi(arg);
            		  break;
        case LAND	: if (!strcasecmp(arg,"true"))
             	            land=TRUE;
             	          else if (!strcasecmp(arg,"false"))
             	             wrap=FALSE;
             	          break;
        case DUP	: dupp = atoi(arg);
            		  break;
        case MF		: if (!strcasecmp(arg,"true"))
            		    mf = TRUE;
            		  else if (!strcasecmp(arg,"false"))
            		    mf = FALSE;
            		  break;
        case TRAY	: tray = atoi(arg);
            		  break;
        case OUTBIN 	: outbin = atoi(arg);
            		  break;
        case PGNO	: if (!strcasecmp(arg,"true"))
            		    pgno=TRUE;
            		  else if (!strcasecmp(arg,"false"))
            		    pgno=FALSE;
            		  break;
        case COPY	: copy = atoi(arg);
            		  if (copy < 1 )
            		     copy =1;
            		  break;
        case HDR	: strcpy (hdr,arg);
#ifdef SYSCC
            		  lm = HDR_LM;
            		  rm = HDR_RM;
            		  bm = HDR_BM;
            		  tm = HDR_TM;
            		  cx = HDR_CX;
            		  cy = HDR_CY;
            		  cs = HDR_CS;
            		  ls = HDR_LS;
            		  pgno = FALSE;
            		  wrap = TRUE;
            		  pt = 4;
            		  px = 595;
            		  py = 842;
#endif SYSCC
            		  break;
        case MPHDR	: strcpy (mphdr,arg);
            		  break;
        case TPL	: if (tpl_page[1] == NULL)
            		    {
            		    if ((tpl_page[1] = malloc(sizeof (struct tpl_pagedata))) == NULL)
            		      q_prog (E_MALLOC,"tpl_pagedata");
            		    tpl_page[1]->cmdlist = NULL;
            		    tpl_page[1]->cmdtail = NULL;
            		    }
            		    
            		  strcpy (tpl_page[1]->tpl_fn,arg);
            		  break;
        case VPRINT	:  
        case HPRINT	:
        case BC39	: 
        case BC25	: 
        case CODABAR	: tpl_command(j,1);
        		  break;
        case MPTPL  	: if ((tpl_pgno = atoi (arg)) >= TPL_PAGE)
            		    q_prog (E_TPLPG,"");
            		  if (tpl_pgno > total_tplpage)
            		    total_tplpage = tpl_pgno;
            		  if (tpl_page[tpl_pgno] == NULL)
            		    {
            		    if ((tpl_page[tpl_pgno] = malloc(sizeof (struct tpl_pagedata))) == NULL)
            		      q_prog (E_MALLOC,"tpl_pagedata");
            		    tpl_page[tpl_pgno]->cmdlist = NULL;
            		    tpl_page[tpl_pgno]->cmdtail = NULL;
            		    }
            		    
            		  sscanf(&tempstr[3],"%s %s %s",cmd,arg,arg1);
            		  strcpy (tpl_page[tpl_pgno]->tpl_fn,arg1);
            		  break;
            		  
        case MPVPRINT	: 
        case MPHPRINT	:
        case MPBC39	: 
        case MPBC25	: 
        case MPCODABAR	: tpl_pgno = atoi (arg);
        		  tpl_command(j,tpl_pgno);
        		  break;
        case FAX_NR	: tempstr[strlen(tempstr)-1]=' ';
        		  if ((phone=strtok(&tempstr[9]," ")) != NULL)
          		    {
          		    cur_faxnr = malloc(sizeof(struct fax_num));
          		    strcpy (cur_faxnr->phone,phone);
          		    cur_faxnr->next = NULL;
          		    if (fax_nr == NULL)
          		      {
          		      fax_nr = cur_faxnr;
          		      last_faxnr = cur_faxnr;
          		      }
          		    else
          		      {
          		      last_faxnr->next = cur_faxnr;
          		      last_faxnr = cur_faxnr;
          		      }
/*        		    fax = TRUE;*/
        		    while ((phone = strtok(NULL," ")) != NULL)
        		      {
        		      cur_faxnr = malloc(sizeof(struct fax_num));
        		      cur_faxnr->next = NULL;
          		      strcpy (cur_faxnr->phone,phone);
          		      last_faxnr->next = cur_faxnr;
          		      last_faxnr = cur_faxnr;
        		      }
        		    }
        		  break; 
        case FAX_SPOOL	: tempstr[strlen(tempstr)-1]=' ';
        		  if ((phone=strtok(&tempstr[12]," ")) != NULL)
          		    {
          		    cur_faxspool = malloc(sizeof(struct fax_num));
          		    strcpy (cur_faxspool->phone,phone);
          		    cur_faxspool->next = NULL;
          		    if (fax_spool == NULL)
          		      {
          		      fax_spool = cur_faxspool;
          		      last_faxspool = cur_faxspool;
          		      }
          		    else
          		      {
          		      last_faxspool->next = cur_faxspool;
          		      last_faxspool = cur_faxspool;
          		      }
/*        		    fax = TRUE;*/
        		    while ((phone = strtok(NULL," ")) != NULL)
        		      {
        		      cur_faxspool = malloc(sizeof(struct fax_num));
        		      cur_faxspool->next = NULL;
          		      strcpy (cur_faxspool->phone,phone);
          		      last_faxspool->next = cur_faxspool;
          		      last_faxspool = cur_faxspool;
        		      }
        		    }
         		  break;
        case EMAIL	:   cur_email = malloc(sizeof(struct email));
          		    strcpy (cur_email->addr,arg);
          		    cur_email->next = NULL;
          		    if (email == NULL)
          		      {
          		      email = cur_email;
          		      last_email = cur_email;
          		      }
          		    else
          		      {
          		      last_email->next = cur_email;
          		      last_email = cur_email;
        		      }
        		    break;
        case COMMENT	:   cur_comm = malloc(sizeof(struct comment));
          		    strcpy (cur_comm->string,&tempstr[11]);
          		    cur_comm->next = NULL;
          		    if (comm == NULL)
          		      {
          		      comm = cur_comm;
          		      last_comm = cur_comm;
          		      }
          		    else
          		      {
          		      last_comm->next = cur_comm;
          		      last_comm = cur_comm;
        		      }
        		  break;
        case NAME	: strcpy (name,&tempstr[8]);
        	          name[strlen(name)-1]=0;
        	          break;
        case FAX_ID	: strcpy (fax_id,&tempstr[10]);
        		  fax_id[strlen(fax_id)-1] = 0;
        		  break;
        default		: cur_err = malloc(sizeof(struct err_cmd));
          		  strcpy (cur_err->command,tempstr);
          		  cur_err->next = NULL;
          		  if (err_cmd == NULL)
          		    {
          		    err_cmd = cur_err;
          		    last_err = cur_err;
          		    }
          		  else
          		    {
          		    last_err->next = cur_err;
          		    last_err = cur_err;
        		    }
        		  break;
        }
      }
    else
      {
/* parse a line of text */ 
      for (i =0 ;i < strlen(tempstr);i++)
        {
        hbyte = tempstr[i];
        lbyte = tempstr[i+1];
        if ((hbyte > 0xa0) && (hbyte < 0xfa) && (((lbyte > 0x3f) && (lbyte < 0x7f))\
|| ((lbyte > 0xa0) && (lbyte < 0xff))))
	  {
	  if (font_count == 0)
	    {
	    total_cchar=1;
	    fl_head = &fontpool[0];
	    fl_tail = fl_head;
	    fl_current = fl_head;
	  
	    fl_current->pre = NULL;
	    fl_current->next = NULL;
	    fl_current->count = 1;
	    fl_current->seq = 0;
	    fl_current->dict = FALSE;
	    fl_current->outline = NULL;
	    (unsigned char)fl_current->code[0]=(unsigned char)hbyte;
	    (unsigned char)fl_current->code[1]=(unsigned char)lbyte;
	  
	    fprintf (tempfile,"\\g%03x",font_count);
	    font_count ++;
	    }
	  else
	    {
 	    for (j = 0 ;j < font_count ;j++)
 	      {
 	      if (((unsigned char)fontpool[j].code[0]==hbyte)&&((unsigned char)fontpool[j].code[1]==lbyte))
 	        {
 	        total_cchar++;
 	        fontpool[j].count++;
 	        fprintf (tempfile,"\\g%03x",j);
 	        fl_current = &fontpool[j];
 	        if (fl_current->pre != NULL)
  	          bubble(fl_current);
 	        break;
 	        }
 	      }
 	    if (j == font_count)
 	      {
 	      total_cchar++;
	      fl_current = &fontpool[font_count];
	      fl_current->seq = font_count;
	      fl_current->count = 1;
	      fl_current->dict = FALSE;
	      fl_current->outline = NULL;
	      fl_current->pre = fl_tail;
	      fl_current->next = NULL;
	      fl_tail->next = fl_current;
	      fl_tail = fl_current;
	      (unsigned char)fl_current->code[0]=(unsigned char)hbyte;
	      (unsigned char)fl_current->code[1]=(unsigned char)lbyte;
	    
	      fprintf (tempfile,"\\g%03x",font_count);
	      if ((++font_count) == FONTNUM)
	        q_prog (E_NO_FD,"");
 	      }  
 	    }
 	  i++;	/* Because Chinese Character is 2 Bytes */
 	  char_count = char_count + 2;
	  }       
        else 
          {
          if ((tempstr[i]=='(') || (tempstr[i]==')') || (tempstr[i] == '\\'))
            {
            fprintf(tempfile,"\\%c",hbyte);
            char_count ++; 
            }
          else if (tempstr[i] == TAB)
            {
            for (j = 0;j< (8 - (char_count%8));j++)
              fprintf(tempfile," ");
            char_count = (char_count/8)* 8 + 8;
            }
          else
            {
            fprintf (tempfile,"%c",tempstr[i]);
            char_count++;
            }
          }
        }
      }
    }
  }


void bubble(struct font_data *current)
  {
  struct font_data *bs[4];
    
  if (current->count > current->pre->count)
    {
    if (current->pre->pre == NULL)
      {
      bs[0] = current;
      bs[1] = current->pre;
      bs[2] = current->next;
      bs[0]->pre = NULL;
      bs[0]->next = bs[1];
      bs[1]->pre = bs[0];
      bs[1]->next = bs[2];
      if (bs[2] != NULL)
        bs[2]->pre = bs[1];
      else
        fl_tail = bs[1];
      fl_head = bs[0];
      }
     else
      {
      bs[0] = current->pre->pre;
      bs[1] = current;
      bs[2] = current->pre;
      bs[3] = current->next;
      bs[0]->next = bs[1];
      bs[1]->pre = bs[0];
      bs[1]->next = bs[2];
      bs[2]->pre = bs[1];
      bs[2]->next = bs[3];
      if (bs[3] != NULL)
        bs[3]->pre = bs[2];
      else
        fl_tail = bs[2];
      }
    if (current->pre != NULL)
      bubble (current);
    }
  }
                                
                                
void tpl_command (int command,int pgno)
  {
  struct tpl_cmd *tmp_cmd;
  char tokenstr[MAXLINE+5];
  char deli[]=" \t";
  
  if (pgno >= TPL_PAGE)
    q_prog(E_TPLPG,"");
  
  if (pgno > total_tplpage)
    total_tplpage = pgno;
   
  if (tpl_page[pgno] == NULL)
    {
    if ((tpl_page[pgno] = malloc(sizeof (struct tpl_pagedata))) == NULL)
      q_prog (E_MALLOC,"tpl_pagedata");
    tpl_page[pgno]->cmdlist = NULL;
    tpl_page[pgno]->cmdtail = NULL;
    }
            		  
  strcpy (tokenstr,tempstr);
  if ((tmp_cmd = malloc(sizeof (struct tpl_cmd))) == NULL)
    {
    printf (" Allocate command struct %d\n\n",(sizeof (struct tpl_cmd)));
    printf ("\n\nError! allocate memory for template printing command! \n\n");
    q_prog(E_MALLOC,"tpl_cmd");
    }
  tmp_cmd->next = NULL;
  
  strtok (tokenstr,deli);
  
  switch (command)
    {
    case MPVPRINT	: 
    case MPHPRINT	: strtok(NULL,deli);
    case VPRINT		:
    case HPRINT		: tmp_cmd->xcoor = atof (strtok(NULL,deli));
    			  tmp_cmd->ycoor = atof (strtok(NULL,deli));
    			  tmp_cmd->fs = atof (strtok(NULL,deli));
    			  tmp_cmd->cs = atof (strtok(NULL,deli));
    			  strcpy (tmp_cmd->ft,strtok(NULL,deli));
    			  strcpy (tmp_cmd->print_str,strstr(tempstr,strtok(NULL,deli)));
    			  break;
    case MPBC39		:
    case MPBC25		:
    case MPCODABAR	: strtok(NULL,deli);
    case BC39		:
    case BC25		:
    case CODABAR	: tmp_cmd->xcoor = atof (strtok(NULL,deli));
    			  tmp_cmd->ycoor = atof (strtok(NULL,deli));
    			  tmp_cmd->fs = atof (strtok(NULL,deli));
    			  tmp_cmd->cs = atof (strtok(NULL,deli));
    			  strcpy (tmp_cmd->print_str,strstr(tempstr,strtok(NULL,deli)));
    			  break;
    }
  switch (command)
    {
    case MPVPRINT	:
    case VPRINT		: tmp_cmd->cmd = TPL_VPRINT;
    			  break;
    case MPHPRINT	:
    case HPRINT		: tmp_cmd->cmd = TPL_HPRINT;
    			  break;
    case MPBC39		:
    case BC39		: tmp_cmd->cmd = TPL_BC39;
    			  break;
    case MPBC25		:
    case BC25		: tmp_cmd->cmd = TPL_BC25;
    			  break;
    case MPCODABAR	:
    case CODABAR	: tmp_cmd->cmd = TPL_CODABAR;
    			  break;
    }  
    
  if (tpl_page[pgno]->cmdlist == NULL)
    {
    tpl_page[pgno]->cmdlist = tmp_cmd;
    tpl_page[pgno]->cmdtail = tmp_cmd;
    }
  else
    {
    tpl_page[pgno]->cmdtail->next = tmp_cmd;
    tpl_page[pgno]->cmdtail = tmp_cmd;
    }
  }         
