/*
  tuxpaint-config.c

  Tux Paint Configuration Tool - A GUI configuration editor for Tux Paint,
                                 a simpel drawing program for children.

  Copyright (c) 2004
  
  Torsten Giebl <wizard@turricane.org>
  Jan Wynholds
  Bill Kendrick <bill@newbreedsoftware.com>

  http://www.newbreedsoftware.com/tuxpaint/
  
  November 12, 2002 - October 2, 2004
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <locale.h>

#include <libintl.h>
#ifndef gettext_noop
#define gettext_noop(String) String
#endif

#include "version.h"
#include "about.h"


#ifdef WIN32

extern char * g_win32_getlocale(void);

#define DOC_PREFIX "docs/"
#define DATA_PREFIX "data/"
#define LOCALEDIR "locale"

#define strcasecmp    stricmp
#define strncasecmp   strnicmp
#define snprintf      _snprintf

#endif

#include <errno.h>

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>

#include "tuxpaint-config2.h"

#ifdef WIN32
/*
 *   The SDL stderr redirection trick doesn't seem to work for perror().
 *     This does pretty much the same thing.
 *     */
void win32_perror(const char *str)
{
  if ( str && *str )
      fprintf(stderr,"%s : ",str);

  fprintf(stderr, "%s [%d]\n",
          (errno<_sys_nerr)?_sys_errlist[errno]:"unknown",errno );
}

#define perror         win32_perror
#endif




/* Local function prototypes: */

void setup(int argc, char * argv[]);
int mainloop(int argc, char * argv[]);


int main(int argc, char * argv[])
{
  setup(argc, argv);

  return ( mainloop(argc, argv) );
}


int mainloop(int argc, char * argv[])
{
    Fl::scheme ("none");	
    Show_TPC_Window ();

    return Fl::run ();
}


void setup(int argc, char * argv[])
{
  int i;
  int show_usage;
  int exit_val;

  show_usage = 0;
  exit_val = 0;

  for (i = 1; i < argc; i++)
  {
    if (strcmp(argv[i], "--help") == 0)
    {
      printf("%s\n", about_text);
      exit(0);
    }
    else if (strcmp(argv[i], "--usage") == 0)
    {
      show_usage = 1;
      exit_val = 0;
    }
    else if (strcmp(argv[i], "--copying") == 0)
    {
      /* FIXME: Copying! */
      printf("\nTux Paint Config. version " VER_VERSION ", " VER_DATE "\n\n");

      printf("This program is free software; you can redistribute it\n"
	     "and/or modify it under the terms of the GNU General Public\n"
	     "License as published by the Free Software Foundation;\n"
	     "either version 2 of the License, or (at your option) any\n"
	     "later version.\n"
	     "\n"
	     "This program is distributed in the hope that it will be\n"
	     "useful and entertaining, but WITHOUT ANY WARRANTY; without\n"
	     "even the implied warranty of MERCHANTABILITY or FITNESS\n"
	     "FOR A PARTICULAR PURPOSE.  See the GNU General Public\n"
	     "License for more details.\n"
	     "\n"
	     "You should have received a copy of the GNU General Public\n"
	     "License along with this program; if not, write to the Free\n"
	     "Software Foundation, Inc., 59 Temple Place, Suite 330,\n"
	     "Boston, MA  02111-1307  USA\n\n");
	exit(0);  
    }
    else if (strcmp(argv[i], "--version") == 0)
    {
      printf("Tux Paint Config. version " VER_VERSION ", " VER_DATE "\n");
      exit(0);
    }
    else
    {
      show_usage = 1;
      exit_val = 1;
    }
  }

  if (show_usage)
  {
    printf("Usage: %s [--version | --copying | --usage | --help]\n",
           argv[0]);

    /* Kluge to get around OS X sending arguments to apps; jdrake 2004-10-02 */
#ifndef __APPLE__
    exit(exit_val);
#endif
  }

  /* Current build stuff doesn't deal with gettext; jdrake 2004-10-02 */
#ifndef __APPLE__

  bindtextdomain("tuxpaint-config", LOCALEDIR);

  textdomain("tuxpaint-config");

#endif
}
