//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef PROCESSSTACK_HH
#define PROCESSSTACK_HH

#include <stdlib.h>

class VHDLType;

struct StackElement {
  int waitLabel;
  VHDLType **args;
  StackElement *next;
  int numArgs;

  StackElement(): waitLabel(-1), args(NULL), next(NULL), numArgs(0) {};
};

class CallStack {
public:
  CallStack() {
    stackTop = NULL;
    stackBottom = NULL;
    numElements = 0;
  };
  virtual ~CallStack() {
    cleanStack();
  }

  bool empty() const;
  void push(StackElement *);
  void push(const int waitLabel, const int numArgs, ...);
  StackElement* pop();
  void popAboveCurrent();
  StackElement* getTop() const;
  StackElement* getCurrentTop() const;
  void setCurrentToNext();
  void setCurrentToTop();

  CallStack& operator = (const CallStack&);

  int stackSize() const { 
    return numElements;
  }

private:
  void cleanStack();

  StackElement *stackTop;
  StackElement *stackBottom;

  // This is used to peek into the stack without actually pushing or
  // popping any item from it.
  StackElement *currentTop;
  int numElements;
};

#endif
