#include "FanDest.hh"
#include "SigEvent.hh"
#include "VHDLKernel.hh"
#include <string>
using std::string;

FanDest::FanDest( const string &initProcessName, int initSigId ) :
  processName( initProcessName ),
  processPtr( 0 ),
  sigId( initSigId ){}

void 
FanDest::sendEvent( SigEvent *toSend, 
		    SimulationObject *sourceProcess ){
  ASSERT( toSend != 0 );
//   ASSERT( toSend->getReceiver() == processName );
  ASSERT( sourceProcess != 0 );
  
  if( processPtr == 0 ){
    processPtr = sourceProcess->getObjectHandle( processName );
  }
  ASSERT( processPtr != 0 );
  
//   cout << endl;
//   cout << "sourceProcess = " << sourceProcess->getName() << endl;
//   cout << "dest = " << processPtr->getName() << endl;
//   cout << "event = " << *toSend << endl;
//   cout << endl;

  processPtr->receiveEvent( toSend );
}

