#ifndef FANDEST_HH
#define FANDEST_HH


#include "tyvis/VHDLKernel.hh"
#include <iostream>

using std::ostream;
class SigEvent;
class SimulationObject;

/** Signal fanout data structure--allows for slices of a signal to have
    different ID's. */

class FanDest {
public:
  FanDest( const string &processName, int initSigId );

  FanDest &operator=( const FanDest &fd ) {
    processName = fd.getProcessName();
    sigId      = fd.getSigId();
    
    return *this;
  }

  const string &getProcessName() const {
    return processName;
  }

  int getSigId() const {
    return sigId;
  }

  void sendEvent( SigEvent *toSend, 
		  SimulationObject *sourceProcess );

private:
  string processName;
  SimulationObject *processPtr;
  int sigId;
};

// inline ostream &operator<<(ostream& os, const FanDest &f ){
//   os << "FanDest: " << f.getProcessPtr()->getName() << ", sigId: " << f.getSigId();

//   return os;
// }

#endif
