//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef REALTYPE_HH
#define REALTYPE_HH

class IntegerType;

#include "tyvis/TypeInfo.hh"
#include "tyvis/ScalarType.hh"

class RealType;
extern RealTypeInfo SavantrealType_info;

class RealType: public ScalarType {
public:
  RealType();
  // RealType(ObjectBase::ObjectType);
  // RealType(ObjectBase::ObjectType, const UniversalReal&);
  // RealType(ObjectBase::ObjectType, const RealType&);
  // RealType(bool, const RealType&);
  RealType(const RealType&);

  RealType(ObjectBase::ObjectType, const TypeInfo& = SavantrealType_info);
  RealType(ObjectBase::ObjectType, const UniversalReal&, const TypeInfo& = SavantrealType_info);
  RealType(ObjectBase::ObjectType, const RealType&, const TypeInfo& = SavantrealType_info);
  RealType(const RealType&, const TypeInfo &);
  RealType(bool, const RealType&, const TypeInfo& = SavantrealType_info);

  virtual ~RealType() {}

  RealType& operator = (const RealType&);

  Type get_kind() const;
  virtual const VHDLData& leftValue();

  //These are the attributes of Real types

  static RealType          LEFT      (const TypeInfo &);
  static RealType          RIGHT     (const TypeInfo &);
  static RealType          HIGH      (const TypeInfo &);
  static RealType          LOW       (const TypeInfo &);
  static EnumerationType   ASCENDING (const TypeInfo &);
  static ArrayType         IMAGE     (const RealType &);
  static RealType          VALUE     (const ArrayType&,
				      const TypeInfo& = SavantrealType_info);
  static RealType          POS       (const RealType&,
				      const TypeInfo& = SavantrealType_info);
  static RealType          VAL       (const RealType&,
				      const TypeInfo& = SavantrealType_info);

  TypeInfo& getTypeInfo() const;


  RealType vhdlPlus( const RValue & ) const;
  RealType vhdlMinus( const RValue & ) const;
  RealType vhdlUnaryPlus() const;
  RealType vhdlUnaryMinus() const;
  RealType vhdlMultiply( const RValue & ) const;
  PhysicalType vhdlMultiply( const PhysicalType & ) const;
  RealType vhdlDivide( const RValue & ) const;
  RealType vhdlPow( const RValue & ) const;
  RealType vhdlAbs() const;
  
public:
  RealTypeInfo range;
};


#endif
