#include "SharedFileType.hh"
#include "SharedFileEvent.hh"
#include <warped/SimulationManager.h>

SignalBase*
SharedFileState::locateSig(int) {
  cerr << "Error : SharedFileState::locateSig(int) called.\n"
       << "      : This method should never get called.\n";

  return NULL;
}

void
SharedFileState::cleanState() {}
  
SharedFileType::SharedFileType( const char *const name, bool alias ) :
  VHDLType(alias),
  VHDLKernel(name),
  openKind( _savant_file_open_kind::READ_MODE ),
  fileName( name ){ }

SharedFileType::SharedFileType(const SharedFileType &sft) :
  VHDLType((const VHDLType &) sft),
  VHDLKernel((const VHDLKernel &) sft),
  openKind( sft.openKind ),
  fileName( sft.getFileName() ){}


SharedFileType::SharedFileType(const char* name,
			       const _savant_file_open_kind mode) :
  VHDLType(false),
  VHDLKernel(name),
  openKind( mode ),
  fileName( name ){}

SharedFileType::SharedFileType(const ArrayType& name,
			       const _savant_file_open_kind mode) :
  VHDLType(false),
  VHDLKernel(name.getString()),
  openKind( mode ),
  fileName( name.getString() ){}

void
SharedFileType::initialize() {
  openFile(fileName, get_fileOpenKind());
}

SharedFileType::~SharedFileType() {}

Type
SharedFileType::get_kind() const {
  return SHARED_FILE_TYPE;
}

ObjectBase::ObjectType
SharedFileType::getKind() const {
  return ObjectBase::VARIABLE;
}

void
SharedFileType::print(ostream &) const {}

VHDLType*
SharedFileType::clone() const{
  cerr << "Error: SharedFileType::clone() const called.\n"
       << "     : This method should never get called.\n";
  
  return NULL;
}


int
SharedFileType::get_fileHandle() const {
  return SHARED_FILE_HANDLE;
}

_savant_file_open_kind&
SharedFileType::get_fileOpenKind() {
  return openKind;
}

void
SharedFileType::set_fileOpenKind(const _savant_file_open_kind& kind) {
  openKind = kind;
}

SharedFileType&
SharedFileType::operator=(const SharedFileType &val) {
  VHDLKernel::operator=( val );
  
  openKind = val.openKind;
  
  return *this;
}

VHDLType&
SharedFileType::operator=(const VHDLType &val) {
  ASSERT ( val.get_kind() == SHARED_FILE_TYPE );

  return operator=((const SharedFileType &) val);
}

bool
SharedFileType::operator==( const RValue &val ) const {
  return (get_fileHandle() == (dynamic_cast< const SharedFileType&>(val).get_fileHandle()));
}
bool
SharedFileType::operator!=( const RValue &val ) const {
  return !operator==( val );
}
bool
SharedFileType::operator<( const RValue & ) const {
  abort();
}
bool
SharedFileType::operator<=( const RValue & ) const {
  abort();
}
bool
SharedFileType::operator>( const RValue & ) const {
  abort();
}
bool
SharedFileType::operator>=( const RValue & ) const {
  abort();
}

State*
SharedFileType::allocateState() {
  return new SharedFileState();
}

void
SharedFileType::executeVHDL( VHDLKernel_state &,
			     Block &,
			     Block & ){
  cerr << "Error - SharedFileType::executeVHDL() called.\n"
       << "      - This method should never get called.\n";
  abort();
}

void
SharedFileType::executeProcess() {
  while (haveMoreEvents() == true) {
    const VHDLEvent *event = dynamic_cast<const VHDLEvent *>(getEvent());
    ASSERT( event != 0 );
    //    ASSERT ( event->getEventKind() == VHDLEvent::SHARED_FILE_EVENT );
    const SharedFileEvent *sfe = dynamic_cast<const SharedFileEvent *>(event);
    if (sfe->isReadRequest() == true) {
      // Read a file from our file...
      int lineSize = 0;
      char *rawData = getline(*fileHandles[0], lineSize);
      string data;
      if( rawData != 0 ){
	data.insert( 0, rawData, lineSize );
      }
      SharedFileEvent *newEvent = new SharedFileEvent( getTimeNow(),
						       getTimeNow(),
						       getName(),
						       sfe->getSender(),
						       data );
						   

      getObjectHandle( newEvent->getReceiver() )->receiveEvent( newEvent );
    }
    else {
      *fileHandles[0] << sfe->getData() << endl;
    }
  }
}
