#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: ultrapossum.rb,v 1.3 2004/10/13 08:56:17 taru Exp $

module UltraPossum

  class Config < Hash

    def initialize( sysconfdir = nil )
      env = ""
      if ! sysconfdir.nil?
        if FileTest.directory?( sysconfdir )
          env = "SYSCONFDIR=#{sysconfdir}"
	else
	  raise "No such directory: #{sysconfdir}"
	end
      end
      open("|sh -c '#{env} ultrapossum-config get'") do |io|
        io.each_line do |line|
          /([^=]+)=\"(.*)\"/ =~ line
          self[$1] = $2
        end
      end
    
    end

  end

end

if __FILE__ == $0
  conf = UltraPossum::Config.new(ARGV[0])
  conf.each_key do |key|
    puts "#{key} -> #{conf[key]}"
  end
end

