/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef REGISTER_H
#define REGISTER_H

#include "types.h"

void REGS_add(Register *r);
Register *REGS_new(char *r);
Register *REGS_find(char *r);
Register *REGS_find_or_new(char *r);
void REGS_flush(Register *r);
void REGS_link(Register *r, Expr *e);
void REGS_drop_to(Register *r, Function *f);
Expr *REGS_expr(Register *r);
char *REGS_name(Register *r);
void REGS_dump_all();

#endif

