/*  $Id: HashMap.h,v 1.4 2005/03/13 04:03:26 sarrazip Exp $
    HashMap.h - Portability wrapper for the C++ hash_map type

    verbiste - French conjugation system
    Copyright (C) 2003-2005 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_HashMap
#define _H_HashMap


/*
    This file includes the appropriate header file to obtain the
    definition of the hash_map type.  It then defines a macro `HashMap'
    that expands to the fully qualified name of the hash_map type.
    The HASH_MAP_HEADER and HASH_MAP_NAMESPACE macros are expected to
    be already defined, typically by the configure script.
*/

#include HASH_MAP_HEADER

#define HashMap HASH_MAP_NAMESPACE::hash_map

#include <string>


/*
    Under g++, we need to define a function object that knows how to
    hash a std::string object.  The namespace directive is only needed
    with version 3 of g++.
*/

#if defined(__GNUG__)

#if __GNUG__ >= 3
namespace HASH_MAP_NAMESPACE {
#endif

    template<> struct hash<std::string>
    {
	size_t operator() (const std::string &x) const
	{
	    return hash<const char*>()(x.c_str());
	}
    };

#if __GNUG__ >= 3
}
#endif

#endif


#endif  /* _H_HashMap */
