/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_APP_CONTROLLER
#define _H_APP_CONTROLLER

#include <Foundation/NSObject.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSNotification.h>
#include <AppKit/NSPanel.h>

#include "DocumentWindowController.h"
#include "ViewPDFDocument.h"
#include "OutlinePanel.h"


@interface AppController : NSObject
{
   id             prefsController;
   OutlinePanel*  outlinePanel;
   NSWindow*      mainWindow;
}

- (id) init;
- (void) dealloc;
+ (void) initialize;

+ (AppController*) sharedController;

- (OutlinePanel*) sharedOutlinePanel;

- (void) applicationDidFinishLaunching: (NSNotification *) aNotification;
- (void) applicationWillFinishLaunching: (NSNotification *) aNotification;

- (DocumentWindowController*) createAndDisplayWindowForDocument: (ViewPDFDocument*)aDocument;

- (void) showPrefs: (id)sender;
- (void) setPrefsController: (id)controller;
- (void) showOutlinePanel: (id)sender;

/* keep track of the current main window.  */
- (void) setMainWindow: (NSWindow*)aWindow;
- (NSWindow*) mainWindow;

@end

#endif
