/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef GRIDVIEW_H
#define GRIDVIEW_H

#include <GraphView.h>

#include <Types.h>

#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qstring.h>
#include <qlist.h>
#include <qpoint.h>
#include <math.h>

class GridView : public GraphView
  {
public:
    GridView( const char * name=0, WFlags f=0 );
    virtual ~GridView();

    void setXAxisTitle(const char* value);
    void setLinXAxis(bool value);
    void setXAxisMin(TReal value);
    void setXAxisMax(TReal value);
    void setNoXSteps(uint value);
    void setYAxisMin(TReal value);
    void setYAxisMax(TReal value);
    void setNoYSteps(uint value);

    const QString& getXAxisTitle() const;
    bool  getLinXAxis() const;
    TReal getXAxisMin() const;
    TReal getXAxisMax() const;
    uint  getNoXSteps() const;
    TReal getYAxisMin() const;
    TReal getYAxisMax() const;
    uint  getNoYSteps() const;

    virtual void draw( QPainter * );
    virtual void drawCursors(QPainter* p);

protected:
    virtual void print( QPainter * );
    
    QRect   graphRect();
    virtual QPoint  toClient( TReal xValue, TReal yValue );
    virtual TComplex fromClient( int x, int y );
    virtual TComplex transformCoordinates( TComplex coord );
    virtual void setDefaults();
    virtual void computeScaling( QPainter * );
    virtual bool isInsideView(const QPoint& p);

private:
    bool  linXAxis_;
    TReal xAxisMax_;
    TReal xAxisMin_;
    TReal yAxisMax_;
    TReal yAxisMin_;
    uint  numberXSteps_;
    uint  numberYSteps_;
    QString xAxisTitle_;

    int graphWidth_;
    int graphHeight_;
    int viewWidth_;
    int viewHeight_;
    int leftGap_;
    int rightGap_;
    int topGap_;
    int bottomGap_;

    TReal xScale_;
    TReal yScale_;

    QRect cursorLegendRect_;

    void drawLabels( QPainter * );
    void drawGrid( QPainter * );

  };

#endif
