/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MODIFYOUTPUTPARAMETERWINDOW_H
#define MODIFYOUTPUTPARAMETERWINDOW_H

#include <qdialog.h>

class QCheckBox;
class QComboBox;
class QRadioButton;
class QVBoxLayout;
class QHButtonGroup;
class ResultDefinition;

class ModifyOutputParameterWindow : public QDialog
{
  Q_OBJECT;
public:
  ModifyOutputParameterWindow( QWidget* parent, const char* name = 0 );
  virtual ~ModifyOutputParameterWindow();
  
  bool initialize( const QString& name, ResultDefinition* definition = 0 );

private slots:
  void ok();
  void cancel();
  void slotDataSourceChanged( int );
  void measurementTypeChanged( int );

private:
  QString name_;
  QVBoxLayout* topLayout_;

  ResultDefinition* definition_;

  QComboBox* measurementType_;
  QComboBox* measurement_;
  QComboBox* dataSource_;
  QComboBox* toPort_;
  QComboBox* fromPort_;
  QHButtonGroup* buttonGroup_;
  QRadioButton* realFormat_;
  QRadioButton* imagFormat_;
  QRadioButton* magFormat_;
  QRadioButton* angFormat_;
  QCheckBox* dbResults_;
};

#endif

