/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef STRINGS_H
#define STRINGS_H

#include <qstring.h>

class Strings
{
public:
  ~Strings();

  static QString translate( const QString& );

  //Entry for language name
  static const QString LanguageName;

  //Window strings
  static const QString MainWindowName;
  static const QString SchematicWindowName;
  static const QString NavigationWindowName;
  static const QString ToolBarName;
  static const QString SymbolBarName;

  //Window titles
  static const QString MainWindowTitle;
  static const QString HelpWindowTitle;
  static const QString NewSchematicWindowTitle;
  static const QString AboutWindowTitle;
  static const QString AboutQtWindowTitle;
  static const QString NewVariableWindowTitle;
  static const QString ModifySweepWindowTitle;
  static const QString ModifyGridWindowTitle;
  static const QString ModifySmithWindowTitle;
  static const QString ChangeVariableWindowTitle;
  static const QString RenameVariableWindowTitle;
  static const QString RenameSubstrateWindowTitle;
  static const QString ChangeDimensionWindowTitle;
  static const QString EditComponentAttributesWindowTitle;
  static const QString RenameSchematicWindowTitle;
  static const QString NewGraphViewWindowTitle;
  static const QString RenameGraphViewWindowTitle;
  static const QString RemoveGraphViewWindowTitle;
  static const QString MicroStripCalcWindowTitle;
  static const QString SchematicSizeWindowTitle;
  static const QString CircuitTunerWindowTitle;
  static const QString DefineSubstrateWindowTitle;
  static const QString OutputParameterDefinitionWindowTitle;
  static const QString SetupLanguageWindowTitle;

  //Status bar messages
  static const QString StatusMessageReady;
  static const QString StatusMessageFileSaved;
  static const QString StatusMessageFileLoaded;
  static const QString StatusMessageCheckingSchematic;
  static const QString StatusMessageSweepingSchematic;
  static const QString StatusMessageSweepingDone;
  static const QString StatusMessageSchematicsOk;
  
  //Menu labels
  static const QString MenuLabelFile;
  static const QString MenuLabelOpen;
  static const QString MenuLabelSave;
  static const QString MenuLabelSaveAs;
  static const QString MenuLabelClose;
  static const QString MenuLabelNewSchematic;
  static const QString MenuLabelPrint;
  static const QString MenuLabelQuit;
  static const QString MenuLabelControls;
  static const QString MenuLabelHelp;
  static const QString MenuLabelIndex;
  static const QString MenuLabelAbout;
  static const QString MenuLabelAboutQt;
  static const QString MenuLabelNewItem;
  static const QString MenuLabelChangeItem;
  static const QString MenuLabelRenameItem;
  static const QString MenuLabelDeleteItem;
  static const QString MenuLabelTools;
  static const QString MenuLabelMicroStripCalc;
  static const QString MenuLabelTuner;
  static const QString MenuLabelView;
  static const QString MenuLabelRefresh;
  static const QString MenuLabelMarkers;
  static const QString MenuLabelToggle;
  static const QString MenuLabelFonts;
  static const QString MenuLabelTitleFont;
  static const QString MenuLabelLabelFont;
  static const QString MenuLabelSetup;
  static const QString MenuLabelLanguage;

  //Message dialog messages
  static const QString MsgConfirmLooseChanges;
  static const QString MsgCouldNotWriteFile;
  static const QString MsgCouldNotOpenFile;
  static const QString MsgNewSchematicName;
  static const QString MsgSchematicAlreadyExists;
  static const QString MsgNewVariableName;
  static const QString MsgVariableAlreadyExists;
  static const QString MsgEnterVariableValue;
  static const QString MsgChangeVariableValue;
  static const QString MsgRenameVariable;
  static const QString MsgConfirmDeleteVariable;
  static const QString MsgRenameSubstrate;
  static const QString MsgConfirmDeleteSubstrate;
  static const QString MsgFloatingNodes;
  static const QString MsgPortNodesShorted;
  static const QString MsgRenameSchematic;
  static const QString MsgConfirmDeleteSchematic;
  static const QString MsgNewGraphView;
  static const QString MsgRenameGraphView;
  static const QString MsgGraphAlreadyExists;
  static const QString MsgConfirmDeleteGraphView;
  static const QString MsgNoSchematicsDefined;
  static const QString MsgNoRangeVariables;
  static const QString MsgMissingAttrValue;
  static const QString MsgUndefinedVariable;
  static const QString MsgVariableHasNoValue;
  static const QString MsgUndefinedSubstrate;
  static const QString MsgUnknownException;
  static const QString MsgOutputContainsInvalidCircuit;
  static const QString MsgStabilityFactorOnlyFor2Port;
  static const QString MsgNoSolutionForCircuit;
  static const QString MsgNumberOfPortsDoesNotMatch;
  static const QString MsgUndefinedBlock;
  static const QString MsgSweepBeyondBlockRange;
  static const QString MsgTakeEffectWhenRestarted;
  
  //Gadget labels
  static const QString LabelApplicationName;
  static const QString LabelFilenameFilter;
  static const QString LabelOk;
  static const QString LabelYes;
  static const QString LabelCancel;
  static const QString LabelSweep;
  static const QString LabelClose;
  static const QString LabelSmall;
  static const QString LabelMedium;
  static const QString LabelLarge;
  static const QString LabelNavigation;
  static const QString LabelGraphName;
  static const QString LabelGraphType;
  static const QString LabelRectangleGraphType;
  static const QString LabelSmithGraphType;
  static const QString LabelTableGraphType;
  static const QString LabelGridTitle;
  static const QString LabelSmithTitle;
  static const QString LabelMinXAxisInput;
  static const QString LabelMaxXAxisInput;
  static const QString LabelNoXAxisTicks;
  static const QString LabelMinYAxisInput;
  static const QString LabelMaxYAxisInput;
  static const QString LabelNoYAxisTicks;
  static const QString LabelPortParameters;
  static const QString LabelLinvillStablilityFactor;
  static const QString LabelSternStabilityFactor;
  static const QString LabelS_Parameters;
  static const QString LabelY_Parameters;
  static const QString LabelZ_Parameters;
  static const QString LabelGroupDelay;
  static const QString LabelMeasurementType;
  static const QString LabelMeasurement;
  static const QString LabelFormat;
  static const QString LabelReal;
  static const QString LabelImag;
  static const QString LabelMagnitude;
  static const QString LabelAngle;
  static const QString LabelResultsInDB;
  static const QString LabelDataSource;
  static const QString LabelToPort;
  static const QString LabelFromPort;
  static const QString LabelTrackProjFreq;
  static const QString LabelAutoSweep;
  static const QString LabelSubstrateName;
  static const QString LabelSubstrateType;
  static const QString LabelMicroStripType;
  static const QString LabelStripLineType;
  static const QString LabelDielectricConst;
  static const QString LabelHeight;
  static const QString LabelConductorThickness;
  static const QString LabelLossTangent;
  static const QString LabelSchematicSize;
  static const QString LabelLanguage;
 
  //Tooltip messages
  static const QString TooltipOpenFile;
  static const QString TooltipSaveFile;
  static const QString TooltipNewSchematic;
  static const QString TooltipPlaceSymbol;
  static const QString TooltipLineSymbol;
  static const QString TooltipToggleGrid;
  static const QString TooltipToggleText;
  static const QString TooltipRotateSymbol;
  static const QString TooltipSweepCircuit;
  static const QString TooltipDeleteSymbol;

  //Component catagories
  static const QString PortCatagory;
  static const QString BlockCatagory;
  static const QString LumpedCatagory;
  static const QString TransmissionLineCatagory;

  //Component names
  static const QString VccsName;
  static const QString GyratorName;
  static const QString ResistorName;
  static const QString CapacitorName;
  static const QString CapacitorQName;
  static const QString InductorName;
  static const QString InductorQName;
  static const QString InductorMName;
  static const QString TransistorName;
  static const QString TLin2PortName;
  static const QString TLin4PortName;
  static const QString TLinPhysicalName;
  static const QString CLinName;
  static const QString SignalGndName;
  static const QString SignalPortName;
  static const QString Block1PortName;
  static const QString Block2PortName;

  //Navigation window items
  static const QString TreeItemSchematics;
  static const QString TreeItemSweep;
  static const QString TreeItemGraphs;
  static const QString TreeItemVariables;
  static const QString TreeItemDimensions;
  static const QString TreeItemSubstrates;
  static const QString TreeItemDataFiles;
  static const QString TreeItemOutputs;

  //Empty filename
  static const QString EmptyFileName;
  static const QString ParameterFileFilter;

  //Sweep elements
  static const QString SweepType;
  static const QString SweepLinearType;
  static const QString SweepLogType;
  static const QString SweepStartFrequency;
  static const QString SweepStopFrequency;
  static const QString SweepNumberOfPoints;

  //Dimension strings
  static const QString FrequencyDim;
  static const QString ResistanceDim;
  static const QString CapacitanceDim;
  static const QString InductanceDim;
  static const QString AngularDim;
  static const QString LengthDim;
  static const QString TimeDim;

  //Component attributes
  static const QString AttrResistance;
  static const QString AttrCapacitance;
  static const QString AttrInductance;
  static const QString AttrPrimaryInductance;
  static const QString AttrSecondaryInductance;
  static const QString AttrImpedance;
  static const QString AttrCoupleFactor;
  static const QString AttrEvenModeImpedance;
  static const QString AttrOddModeImpedance;
  static const QString AttrElectricalLng;
  static const QString AttrElectricalLngFreq;
  static const QString AttrSubstrateName;
  static const QString AttrPortImpedance;
  static const QString AttrBlockname;
  static const QString AttrQFactor;
  static const QString AttrTransConductance;
  static const QString AttrGyratorFactor;
  static const QString AttrLineWidth;
  static const QString AttrLineLength;

  //Microstrip calculator strings
  static const QString CalcDielectricConstant;
  static const QString CalcSubstraceHeight;
  static const QString CalcFrequency;
  static const QString CalcLineLength;
  static const QString CalcLineWidth;
  static const QString CalcElectricalLength;
  static const QString CalcLineImpedance;
  static const QString CalcElectrical;
  static const QString CalcPhysical;
  static const QString CalcDegrees;
  static const QString CalcImpedance;

private:
  Strings();
};

#endif
