#ifndef EVENT_SET_FACTORY_H
#define EVENT_SET_FACTORY_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "EventSet.h"
#include "Configurer.h"

class Event;

/** The EventSetFactory class.

This is the class interface for the various event set
implementations that are available in the Simulation kernel. The
specific event set implementation is hidden from the other
components of the simulation kernel by the aggregation of the
event set implemetations in this class (factory pattern).  All
event set implementations must be derived from the EventSet
abstract base class.

*/
class EventSetFactory : virtual public Configurer {

public:

  /**@name Public Class Methods of EventSetFactory. */
  //@{

  /// Default Constructor
  EventSetFactory();

  /// Destructor
  virtual ~EventSetFactory();

  /** Set the configured event set implementation.
       
  Function to attach the particular event set implementation in
  the kernel. Will be called by the configuration step to set the
  appropriate event set implementation.

  @param configurationMap Map of configuration choices.
  */
  Configurable *allocate( SimulationConfiguration &configuration,
			  Configurable *parent ) const;
   
  static const EventSetFactory *instance();

  //@} // End of Public Class Methods of EventSetFactory.
   
protected:
   
  /**@name Private Class Attributes of EventSetFactory. */
  //@{

  //@} // End of Private Class Attributes of EventSetFactory.
   
};

#endif
