#include "GVTUpdateMessage.h"
#include "DeserializerManager.h"

void 
GVTUpdateMessage::serialize( SerializedInstance *addTo ) const {
  KernelMessage::serialize( addTo );
  addTo->addSerializable( newGVT );
}

Serializable *
GVTUpdateMessage::deserialize( SerializedInstance *data ){
  unsigned int source = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  VTime *newGVT = dynamic_cast<VTime *>(data->getSerializable());

  return new GVTUpdateMessage( source,
			       dest,
			       *newGVT );
  delete newGVT;
}

const string &
GVTUpdateMessage::getGVTUpdateMessageType(){
  static const string gVTUpdateMessageType = "GVTUpdateMessageType";
  return gVTUpdateMessageType;
}


void GVTUpdateMessage::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getGVTUpdateMessageType(),
							 &deserialize );

}
