// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: 
//          
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: NullVisualizationManager.h
// 
//---------------------------------------------------------------------------

#include "NullVisualizationManager.h"


NullVisualizationManager::NullVisualizationManager(TimeWarpSimMgrWithVisualization *mySimMgr) : VisualizationManager(mySimMgr) {}

NullVisualizationManager::~NullVisualizationManager() {}

int 
NullVisualizationManager::openVisualizationObject(const char *, VisualizationManager::DisplayKind, NullVisualizationManager::VisualizationTools) {
  return 0; // Quiet the compiler down.
}
 

int 
NullVisualizationManager::openVisualizationObject(const char *, VisualizationManager::DisplayKind, VisualizationManager::VisualizationTools,  VisualizationManager::DataType, void *) {
  return 0; // Quiet the compiler down.
}


void 
NullVisualizationManager::closeVisualizationObject(int) {}

void 
NullVisualizationManager::addListener(int, void *) {}

void 
NullVisualizationManager::updateVisalizationValue(int) {}

