#!/usr/bin/perl
#
# rule_status.cgi
#
# This script accepts input via a GET request to enable or disable
# a specific set of Snort rules

# Do common initialization and get common routines
require 'snort-lib.pl';
ReadParse();

$whatfailed = "Unable to switch ruleset status";
&snort_error($text{'rule_status_norule'}) if (!$in{'rule'}); 

# Check if user can switch rule status

# Read in rule config data
$conf = &get_config("rule");

# Make sure the rule actually exists
&snort_error($text{'rule_status_rulenf'}, ": ", $in{'rule'}) if (!$$conf{$in{'rule'}});

# Lets update the tuple
$newtuple = "include " . $in{'rule'} . ".rules\n";
$newtuple = "#" . $newtuple if (!$$conf{$in{'rule'}}->{'disabled'});

# Lock the file for the update and update the tuple
lock_file($config{'snort_config'});
&replace_file_line($config{'snort_config'}, $$conf{$in{'rule'}}->{'line'}, $newtuple);
unlock_file($config{'snort_config'});

# Log the change
&webmin_log("rule_status", undef, $config{'snort_config'},
	    { 'file' => $config{'snort_config'} });

# Redirect user back to main page
&redirect("index.cgi");
