#!/usr/local/bin/perl
# Create or delete a database

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'edit_ecannot'});

if ($in{'new'}) {
	# Create one, after checking for clashes
	&error_setup($text{'database_err'});
	$in{'name'} =~ /^[a-z0-9\-\_]+$/i ||
		&error($text{'database_ename'});
	$cfunc = "check_".$in{'type'}."_database_clash";
	&$cfunc($d, $in{'name'}) &&
		&error($text{'database_eclash'});
	if ($d->{'mailboxlimit'}) {
		@dbs = &domain_databases($d);
		@dbs < $d->{'mailboxlimit'} || &error($text{'database_elimit'});
		}

	# Go for it
	&ui_print_header(&domain_in($d), $text{'database_title1'}, "");
	$crfunc = "create_".$in{'type'}."_database";
	&$crfunc($d, $in{'name'});
	&save_domain($d);
	&update_webmin_dbs();
	}
elsif ($in{'delete'} && !$in{'confirm'}) {
	# Ask the user if he wants to delete
	&ui_print_header(&domain_in($d), $text{'database_title3'}, "");
	print "<center>",&text('database_rusure', $in{'name'}),"<p>\n";
	print &ui_form_start("save_database.cgi", "post");
	foreach $i ("dom", "name", "type", "delete") {
		print &ui_hidden($i, $in{$i}),"\n";
		}
	print &ui_submit($text{'database_ok'}, "confirm"),"</center>\n";
	print &ui_form_end();
	}
elsif ($in{'delete'}) {
	# Delete now
	&ui_print_header(&domain_in($d), $text{'database_title3'}, "");
	$dfunc = "delete_".$in{'type'}."_database";
	&$dfunc($d, $in{'name'});
	&save_domain_print($d);
	&update_webmin_dbs();
	}
elsif ($in{'disc'}) {
	# Remove from server's list
	&ui_print_header(&domain_in($d), $text{'database_title4'}, "");
	@dbs = split(/\s+/, $d->{'db_'.$in{'type'}});
	@dbs = grep { $_ ne $in{'name'} } @dbs;
	$d->{'db_'.$in{'type'}} = join(" ", @dbs);
	&save_domain_print($d);
	&update_webmin_dbs();
	}

&ui_print_footer("list_databases.cgi?dom=$in{'dom'}", $text{'databases_return'},
		 "edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		 "", $text{'index_return'});

sub update_webmin_dbs
{
if ($d->{'parent'}) {
	# Refresh parent Webmin user
	$parentdom = &get_domain($d->{'parent'});
	&modify_webmin($parentdom, $parentdom);
	}
else {
	&modify_webmin($d, $d);
	}
}

sub save_domain_print
{
&$first_print($text{'setup_save'});
&save_domain($_[0]);
&$second_print($text{'setup_done'});
}
