/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFLOGENTRIES_H
#define _WFLOGENTRIES_H

#include <iostream>
#include <list>

#include "wflogentry.h"
#include "wflogs_filter.h"
#include "wflogs_obfuscator.h"

/**
 * 
 */
class wf_logentries {
 public:
  wf_logentries();
  virtual ~wf_logentries() {}
  wf_logentries(const wf_logentries&);
  wf_logentries& operator=(const wf_logentries& logentries);

  bool add(const wf_logentry& logentry);

  bool filter(wflogs_filter& myfilter, unsigned int* deleted_entries = NULL);
  bool obfuscate(const wflogs_obfuscator& myobfuscator);
  bool summary(unsigned int* deleted_entries);
  
  ostream& debugprint(ostream& os) const;
  
 public:
  list<wf_logentry*> elems;
};

#endif
