/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef WFTK_REF_OBJ_H
#define WFTK_REF_OBJ_H

#include <cassert>
#include <SDL/SDL_types.h> // for Uint32

namespace wftk {

class RefCountObj {
 public:
  // a 0 refcount, but not deleted, acts as a 'floating' reference
  RefCountObj(bool floating) : refcount_(floating ? 0 : 1) {}
  virtual ~RefCountObj() {}

  /// increase the widget's refcount
  void ref() {++refcount_;}
  /// decrease the widget's refcount
  void unref() {assert(refcount_); if(!--refcount_) delete this;}
  /// drop the widget's floating reference
  /**
   * Floating objects are created with a floating reference which is
   * automagically dropped the first time ref() is called,
   * typically when the widget is packed into another widget.
   * This drops the floating reference, if present, but doesn't
   * otherwise affect the refcount.
   **/
  void sink() {if(!refcount_) delete this;}

 private:
  // unimplemented
  RefCountObj(const RefCountObj&);
  RefCountObj& operator=(const RefCountObj&);

  Uint32 refcount_;
};

} // namespace

#endif // WFTK_REF_OBJ_H
