#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

/******************

This is wild

******************/

@interface NSMenu (HorizontalHackery)
- (void) _organizeMenu;
@end

@implementation NSMenu (HorizontalHackery)

#define SHIFT_DELTA 18.0

- (void) shiftOnScreen
{
  NSWindow *theWindow = _transient ? _bWindow : _aWindow;
  NSRect    frameRect = [theWindow frame];
  NSRect    screenRect = [[NSScreen mainScreen] frame];
  NSPoint   vector    = {0.0, 0.0};
  BOOL      moveIt    = NO;

  // If we are the main menu forget about moving.
  if ([self isEqual: [NSApp mainMenu]])
    return;

  // 1 - determine the amount we need to shift in the y direction.
  if (NSMinY (frameRect) < 0)
    {
      vector.y = MIN (SHIFT_DELTA, -NSMinY (frameRect));
      moveIt = YES;
    }
  else if (NSMaxY (frameRect) > NSMaxY (screenRect))
    {
      vector.y = -MIN (SHIFT_DELTA, NSMaxY (frameRect) - NSMaxY (screenRect));
      moveIt = YES;   
    }

  // 2 - determine the amount we need to shift in the x direction.
  if (NSMinX (frameRect) < 0)
    {
      vector.x = MIN (SHIFT_DELTA, -NSMinX (frameRect));
      moveIt = YES;
    }
  // Note the -3.  This is done so the menu, after shifting completely
  // has some spare room on the right hand side.  This is needed otherwise
  // the user can never access submenus of this menu.   
  else if (NSMaxX (frameRect) > NSMaxX (screenRect) - 3)
    {
      vector.x
        = -MIN (SHIFT_DELTA, NSMaxX (frameRect) - NSMaxX (screenRect) + 3);
      moveIt = YES;
    }
     
  // This has been hacked for horizontal menus, i.e. we only scroll the 
  // menu that is off the screen.
  if (moveIt)
    {
      NSPoint  masterLocation;
      NSPoint  destinationPoint;
     
      masterLocation = [[self window] frame].origin;
      destinationPoint.x = masterLocation.x + vector.x;
      destinationPoint.y = masterLocation.y + vector.y;

      [self nestedSetFrameOrigin: destinationPoint];
    }
}

- (void) _rightMouseDisplay: (NSEvent*)theEvent 
{
  NSLog(@"Right menu click disabled for the moment.");
}

- (void)setGeometry
{
  NSPoint origin;
  origin = NSMakePoint (0, [[NSScreen mainScreen] frame].size.height - [_aWindow frame].size.height);
  [_aWindow setFrameOrigin: origin];
  [_bWindow setFrameOrigin: origin];
}

-(void) _updateUserDefaults:(id)notification
{
  /*
    NSLog(@"not going to update because we don't use this and might mess something up for other menu layouts since they seem to draw from the bottom up and our bottom is really close to the top");
  */
}

- (void) _organizeMenu
{
  NSMenu *appMenu = [[self itemWithTitle: [[NSProcessInfo processInfo] processName]] submenu];

  if (![self isEqual: [NSApp mainMenu]])
    return;

  if (appMenu == nil)
    {
      int i;
      NSMutableArray *itemsToMove = [NSMutableArray new];
      NSMenuItem *appItem;
      NSImage *ti = [[NSApp applicationIconImage] copy];
      float bar = [NSMenuView menuBarHeight] - 4;

      appMenu = [NSMenu new];

      for (i = 0; i < [_items count]; i++)
        {
          NSMenuItem *anItem = [_items objectAtIndex: i];
          NSString *title = [anItem title];

          if (![anItem submenu])
	    {
	      [itemsToMove addObject: anItem];
	    }

          if ([title isEqual: NSLocalizedString (@"Info",
                                           @"Info")])
	    {
	      [itemsToMove addObject: anItem];
	    }
        }

      for (i = 0; i < [itemsToMove count]; i++)
        {
          [self removeItem: [itemsToMove objectAtIndex: i]];
          [appMenu addItem: [itemsToMove objectAtIndex: i]];
        }

      [self insertItemWithTitle: [[NSProcessInfo processInfo] processName]
		         action: NULL
	          keyEquivalent: @"" 
                        atIndex: 0];
      appItem = [self itemWithTitle: [[NSProcessInfo processInfo] processName]];

      if (!ti)
        ti = [[NSImage imageNamed: @"GNUstep.tiff"] copy];

      [ti setScalesWhenResized: YES];
      [ti setSize: NSMakeSize(bar, bar)];
      [appItem setImage: ti];
      RELEASE (ti);

      [self setSubmenu: appMenu forItem: appItem];

      [itemsToMove release];
    }
  else
    {
      int i;
      NSMutableArray *itemsToMove = [NSMutableArray new];
      NSMenuItem *appItem = [self itemWithTitle: [[NSProcessInfo processInfo] processName]];
      int index = [self indexOfItem: appItem];
      NSImage *ti = [[NSApp applicationIconImage] copy];
      float bar = [NSMenuView menuBarHeight] - 4;

      if (!ti)
        ti = [[NSImage imageNamed: @"GNUstep.tiff"] copy];

      [ti setScalesWhenResized: YES];
      [ti setSize: NSMakeSize(bar, bar)];
      [appItem setImage: ti];
      RELEASE (ti);

      if (index != 0)
        {
	  RETAIN (appItem);
	  [self removeItemAtIndex: index];
	  [self insertItem: appItem atIndex: 0];
	  RELEASE (appItem);
        }

      for (i = 0; i < [_items count]; i++)
        {
          NSMenuItem *anItem = [_items objectAtIndex: i];
          NSString *title = [anItem title];

          if (![anItem submenu])
	    {
	      [itemsToMove addObject: anItem];
	    }

          if ([title isEqual: NSLocalizedString (@"Info",
                                           @"Info")])
	    {
	      [itemsToMove addObject: anItem];
	    }
        }

      for (i = 0; i < [itemsToMove count]; i++)
        {
          [self removeItem: [itemsToMove objectAtIndex: i]];
          [appMenu addItem: [itemsToMove objectAtIndex: i]];
        }

      [itemsToMove release];
    }
}
@end

@interface MHMenuItemCell : NSMenuItemCell
@end

@implementation MHMenuItemCell
- (NSRect) drawingRectForBounds: (NSRect)theRect
{
  return theRect;
}

- (void) drawBorderAndBackgroundWithFrame: (NSRect)cellFrame
                                   inView: (NSView *)controlView
{
}
@end

@interface GSHorizontalMenuItemCell : NSMenuItemCell
{
}
@end

@implementation GSHorizontalMenuItemCell
- (id) init
{
  [super init];
  _target = nil;
  _highlightsByMask = NSChangeBackgroundCellMask;
  _showAltStateMask = NSNoCellMask;
  _cell.image_position = NSNoImage;
  [self setAlignment: NSCenterTextAlignment];
  [self setFont: [NSFont boldSystemFontOfSize: 0]];

  return self;
}

- (NSRect) drawingRectForBounds: (NSRect)theRect
{
  return NSMakeRect (theRect.origin.x,
                     theRect.origin.y,
                     theRect.size.width,
                     theRect.size.height);
}

- (NSRect) imageRectForBounds:(NSRect)cellFrame
{
  switch (_cell.image_position)
    {
    case NSNoImage:
      cellFrame = NSZeroRect;
      break;
      
    case NSImageOnly:
    case NSImageOverlaps:
      break;
      
    case NSImageLeft:
      cellFrame.origin.x  += 4.; // _horizontalEdgePad
      cellFrame.size.width = _imageWidth;
      break;
  
    case NSImageRight:
      cellFrame.origin.x  += _titleWidth;
      cellFrame.size.width = _imageWidth;
      break;
     
    case NSImageBelow:
      cellFrame.size.height /= 2;
      break;
      
    case NSImageAbove:
      cellFrame.size.height /= 2;
      cellFrame.origin.y += cellFrame.size.height;
      break;
    }
      
  return cellFrame;
} 

- (NSRect) titleRectForBounds:(NSRect)cellFrame
{
  switch (_cell.image_position)
    {
      case NSNoImage:
      case NSImageOverlaps:
        break;
  
      case NSImageOnly:
        cellFrame = NSZeroRect;
        break;
    
      case NSImageLeft:
        cellFrame.origin.x  += 4 + _imageWidth + xDist; // _horizontalEdgePad
        cellFrame.size.width = _titleWidth;
        break;
        
      case NSImageRight:
        cellFrame.size.width = _titleWidth;
        break;
                 
      case NSImageBelow:
        cellFrame.size.height /= 2;
        cellFrame.origin.y += cellFrame.size.height;
        break;

      case NSImageAbove:
        cellFrame.size.height /= 2;
        break;
    }

  return cellFrame;
}

- (void) drawBorderAndBackgroundWithFrame: (NSRect)cellFrame
                                  inView: (NSView *)controlView
{
}

- (void) drawInteriorWithFrame: (NSRect)cellFrame inView: (NSView*)controlView
{
  unsigned  mask;
  NSColor *backgroundColor = nil;

  // Transparent buttons never draw
  if (_buttoncell_is_transparent)
    return;
     
  cellFrame.origin.y += 2.;
  cellFrame.size.height -= 2.;

  if (_cell.is_highlighted)
    {
      mask = _highlightsByMask;

      if (_cell.state)
        mask &= ~_showAltStateMask;
    }
  else if (_cell.state)
    mask = _showAltStateMask;
  else
    mask = NSNoCellMask;

  /* 
   * Determine the background color and cache it in an ivar so that the
   * low-level drawing methods don't need to do it again.
   */
  if (mask & (NSChangeGrayCellMask | NSChangeBackgroundCellMask))
    {
      backgroundColor = [NSColor selectedMenuItemColor];
    }
  if (backgroundColor == nil)
    backgroundColor = [NSColor controlBackgroundColor];

  // Set cell's background color
  [backgroundColor set];
  NSRectFill(cellFrame);
  if (mask & NSContentsCellMask)
    {
      _imageToDisplay = _altImage;
      if (!_imageToDisplay)
        _imageToDisplay = [_menuItem image];
      _titleToDisplay = _altContents;
      if (_titleToDisplay == nil || [_titleToDisplay isEqual: @""])
        _titleToDisplay = [_menuItem title];
    }
  else
    {
      _imageToDisplay = [_menuItem image];
      _titleToDisplay = [_menuItem title];
    }
   
  if (_imageToDisplay)
    {
      _imageWidth = [_imageToDisplay size].width;
    }
      
  // Draw the image
  if (_imageWidth > 0)
    [self drawImageWithFrame: cellFrame inView: controlView];
     
  // Draw the title
  if (_titleWidth > 0)
    [self drawTitleWithFrame: cellFrame inView: controlView];
}

- (void) drawTitleWithFrame:(NSRect)cellFrame
                    inView:(NSView *)controlView
{
  id value = [NSMutableParagraphStyle defaultParagraphStyle];
  NSDictionary *attr;
  NSRect cf = [self titleRectForBounds: cellFrame];
  NSSize titleSize;

  // hack to get vertical alignment.
  cf.origin.y += 1;
  cf.size.height -= 1;

  if (!_imageWidth)
    [value setAlignment: NSCenterTextAlignment];

  attr = [[NSDictionary alloc] initWithObjectsAndKeys:
                               value, NSParagraphStyleAttributeName,
                               _font, NSFontAttributeName,
                               [NSColor controlTextColor], NSForegroundColorAttributeName,
                               nil];

  if ([_menuItem isEnabled])
    _cell.is_disabled = NO;
  else
    _cell.is_disabled = YES;

  /** Important: text should always be vertically centered without
   * considering descender [as if descender did not exist].
   * This is particularly important for single line texts.
   * Please make sure the output remains always correct.
   */
  titleSize = [[_menuItem title] sizeWithAttributes: attr];
  cf.origin.y = NSMidY (cf) - titleSize.height/2;
  cf.size.height = titleSize.height;

  [[_menuItem title] drawInRect: cf
          withAttributes: attr];

  RELEASE(attr);
}
@end

typedef struct _GSCellRect {
  NSRect rect;
} GSCellRect;

#define GSI_ARRAY_TYPES       0
#define GSI_ARRAY_TYPE  GSCellRect

#define GSI_ARRAY_NO_RETAIN
#define GSI_ARRAY_NO_RELEASE
 
#ifdef GSIArray
#undef GSIArray
#endif
#include <GNUstepBase/GSIArray.h>

@interface NSMenuView (Hackery)
@end

@implementation NSMenuView (Hackery)
- (NSRect) rectOfItemAtIndex: (int)index
{
  NSRect theRect;
      
  if (_needsSizing == YES)
    {
      [self sizeToFit];
    }
      
  /* Fiddle with the origin so that the item rect is shifted 1 pixel over
   */
  theRect.size = _cellSize;

  if (_horizontal == NO)
    { 
      if (![_attachedMenu _ownedByPopUp])
        {
          theRect.origin.y = 2 + (_cellSize.height * ([_itemCells count] - 
						  index - 1));
          theRect.origin.x = 1;
          theRect.size.width -= 2;
        }
      else
        {
          theRect.origin.y = _cellSize.height * ([_itemCells count] - index - 1);
      	  theRect.origin.x = _leftBorderOffset;
        }
    }
  else
    {
      // FIXME: or remove?
      theRect.origin.x = _cellSize.width * (index + 1);
      theRect.origin.y = 0;
    }
      
  /* NOTE: This returns the correct NSRect for drawing cells, but nothing
   * else (unless we are a popup). This rect will have to be modified for
   * event calculation, etc..
   */ 
  return theRect;
}

- (NSPoint) locationForSubmenu: (NSMenu *)aSubmenu
{
  NSRect frame = [_window frame];
  NSRect submenuFrame;  
     
  if (_needsSizing)
    [self sizeToFit];

  if (aSubmenu)
    submenuFrame = [[[aSubmenu menuRepresentation] window] frame];
  else
    submenuFrame = NSZeroRect;
            
  if (_horizontal == NO)
    {
      NSRect aRect = [self rectOfItemAtIndex:
            [_attachedMenu indexOfItemWithSubmenu: aSubmenu]];
      NSPoint subOrigin = [_window convertBaseToScreen:
            NSMakePoint(aRect.origin.x, aRect.origin.y)];
    
      return NSMakePoint (NSMaxX(frame),
                          subOrigin.y - NSHeight(submenuFrame) + aRect.size.height);
    }
  else
    {
      NSRect aRect = [self rectOfItemAtIndex:
                       [_attachedMenu indexOfItemWithSubmenu: aSubmenu]];
      NSPoint subOrigin = [_window convertBaseToScreen:
                                    NSMakePoint(NSMinX(aRect),
                                    NSMinY(aRect))];
          
      return NSMakePoint(subOrigin.x, subOrigin.y - NSHeight(submenuFrame));
    }
}

- (void) itemAdded: (NSNotification*)notification
{
  int         index  = [[[notification userInfo] 
                          objectForKey: @"NSMenuItemIndex"] intValue];
  NSMenuItem *anItem = [_items_link objectAtIndex: index];
  id          aCell;
  int wasHighlighted = _highlightedItemIndex;

  if (![_attachedMenu _ownedByPopUp])
    aCell = [MHMenuItemCell new];
  else
    aCell = [NSMenuItemCell new];

  [aCell setMenuItem: anItem];
  [aCell setMenuView: self];
  [aCell setFont: _font];

  /* Unlight the previous highlighted cell if the index of the highlighted
   * cell will be ruined up by the insertion of the new cell.  */
  if (wasHighlighted >= index)
    {
      [self setHighlightedItemIndex: -1];
    }
 
  [_itemCells insertObject: aCell atIndex: index];
                          
  /* Restore the highlighted cell, with the new index for it.  */
  if (wasHighlighted >= index)
    {
      /* Please note that if wasHighlighted == -1, it shouldn't be possible
       * to be here.  */
      [self setHighlightedItemIndex: ++wasHighlighted];
    }

  [aCell setNeedsSizing: YES];
  RELEASE(aCell);

  // Mark the menu view as needing to be resized.
  [self setNeedsSizing: YES];
}

- (void) sizeToFit
{
  unsigned i;
  unsigned howMany = [_itemCells count];
  unsigned wideTitleView = 1;
  float    neededImageAndTitleWidth = 0.0;
  float    neededKeyEquivalentWidth = 0.0;
  float    neededStateImageWidth = 0.0;
  float    accumulatedOffset = 0.0;
  float    popupImageWidth = 0.0;
  float    menuBarHeight = 0.0;

  // Popup menu doesn't need title bar
  if (![_attachedMenu _ownedByPopUp])
    {
      if ([_attachedMenu supermenu] != nil)
        {
          NSMenuItemCell *msr = [[[_attachedMenu supermenu] menuRepresentation] 
			menuItemCellForItemAtIndex:
			[[_attachedMenu supermenu] indexOfItemWithTitle: [_attachedMenu title]]];
          neededImageAndTitleWidth += [msr titleWidth] + xDist;
        }

      if (_titleView)
        menuBarHeight = [[self class] menuBarHeight];
      else
	menuBarHeight += 3; // 2 on bottom, 1 on top
    }
  else
    {
      menuBarHeight += _leftBorderOffset;
    }

  for (i = 0; i < howMany; i++)
    {
      float aStateImageWidth;
      float aTitleWidth;
      float anImageWidth;
      float anImageAndTitleWidth;
      float aKeyEquivalentWidth;
      NSMenuItemCell *aCell = [_itemCells objectAtIndex: i];
     
      // State image area.
      aStateImageWidth = [aCell stateImageWidth];
     
      // Title and Image area.
      aTitleWidth = [aCell titleWidth];
      anImageWidth = [aCell imageWidth]; 
     
      // Key equivalent area.
      aKeyEquivalentWidth = [aCell keyEquivalentWidth];
     
      switch ([aCell imagePosition])
        {
        case NSNoImage:  
          anImageAndTitleWidth = aTitleWidth;
          break;
      
        case NSImageOnly:
          anImageAndTitleWidth = anImageWidth;
          break;
     
        case NSImageLeft:
        case NSImageRight:
          anImageAndTitleWidth = anImageWidth + aTitleWidth + xDist;
          break;

        case NSImageBelow:
        case NSImageAbove:
        case NSImageOverlaps:
        default:
          if (aTitleWidth > anImageWidth)
            anImageAndTitleWidth = aTitleWidth;
          else  
            anImageAndTitleWidth = anImageWidth;
          break;
        }
          
      if (aStateImageWidth > neededStateImageWidth)
        neededStateImageWidth = aStateImageWidth;
        
      if (anImageAndTitleWidth > neededImageAndTitleWidth)
        neededImageAndTitleWidth = anImageAndTitleWidth;

      if (aKeyEquivalentWidth > neededKeyEquivalentWidth)
        neededKeyEquivalentWidth = aKeyEquivalentWidth;
        
      // Title view width less than item's left part width
      if ((anImageAndTitleWidth + aStateImageWidth)
          > neededImageAndTitleWidth)
        wideTitleView = 0;
      
      // Popup menu has only one item with nibble or arrow image
      if (anImageWidth)
        popupImageWidth = anImageWidth;
    }
        
  // Cache the needed widths.
  _stateImageWidth = neededStateImageWidth;
  _imageAndTitleWidth = neededImageAndTitleWidth;
  _keyEqWidth = neededKeyEquivalentWidth;
      
  accumulatedOffset = _horizontalEdgePad;
  if (howMany)
    {
      // Calculate the offsets and cache them.
      if (neededStateImageWidth)
        {
          _stateImageOffset = accumulatedOffset;
          accumulatedOffset += neededStateImageWidth += _horizontalEdgePad;
        }
        
      if (neededImageAndTitleWidth)
        {
          _imageAndTitleOffset = accumulatedOffset;
          accumulatedOffset += neededImageAndTitleWidth;
        }

      if (wideTitleView)
        {
          _keyEqOffset = accumulatedOffset = neededImageAndTitleWidth
            + (3 * _horizontalEdgePad);
        }
      else
        {
          _keyEqOffset = accumulatedOffset += (2 * _horizontalEdgePad);
        }
      accumulatedOffset += neededKeyEquivalentWidth + _horizontalEdgePad;
        
      if ([_attachedMenu supermenu] != nil && neededKeyEquivalentWidth < 8)
        {
          accumulatedOffset += 8 - neededKeyEquivalentWidth;
        }
    }
  else
    {
      accumulatedOffset += neededImageAndTitleWidth + 3 + 2;
      if ([_attachedMenu supermenu] != nil)
        accumulatedOffset += 15;
        accumulatedOffset += 15;
    }

  // Calculate frame size.
  if (![_attachedMenu _ownedByPopUp])
    {
      // Add the border width: 1 for left, 2 for right sides
      _cellSize.width = accumulatedOffset + 3;
    }
  else   
    {
      _keyEqOffset = _cellSize.width - _keyEqWidth - popupImageWidth;
    }

  if (_horizontal == NO)
    {
      [self setFrameSize: NSMakeSize(_cellSize.width + _leftBorderOffset,
                                     (howMany * _cellSize.height)
                                     + menuBarHeight)];
      [_titleView setFrame: NSMakeRect (0, howMany * _cellSize.height,
                                        NSWidth (_bounds), menuBarHeight)];
    }
  else
    {
      [self setFrameSize: NSMakeSize(((howMany + 1) * _cellSize.width),
                                     _cellSize.height + _leftBorderOffset)];
      [_titleView setFrame: NSMakeRect (0, 0,
                                        _cellSize.width, _cellSize.height + 1)];
    }
     
  _needsSizing = NO;
}

- (void) update
{
  [self sizeToFit];
}

- (void) drawRect: (NSRect)rect
{
  int        i;
  int        howMany = [_itemCells count];

  if (![_attachedMenu _ownedByPopUp])
    {
      NSDrawButton (_bounds, rect);
    }
  else
    {
      NSRectEdge sides[] = {NSMinXEdge, NSMaxYEdge};
      float      grays[] = {NSDarkGray, NSDarkGray}; 
      // Draw the dark gray upper left lines.
      NSDrawTiledRects(_bounds, rect, sides, grays, 2);
    }

  // Draw the menu cells.
  for (i = 0; i < howMany; i++)
    {
      NSRect            aRect;
      NSMenuItemCell    *aCell;
 
      aRect = [self rectOfItemAtIndex: i];
      if (NSIntersectsRect(rect, aRect) == YES)
        {
          aCell = [_itemCells objectAtIndex: i];
          [aCell drawWithFrame: aRect inView: self];
        }
    }
}
@end

@interface GSHorizontalMenuView : NSMenuView
{
  GSIArray _cellRects;
}
@end

@implementation GSHorizontalMenuView
- (id) initWithFrame: (NSRect)aFrame
{
  NSZone *zone;
  
  self = [super initWithFrame: aFrame];
  zone = GSObjCZone(self);
  _cellRects = NSZoneMalloc(zone, sizeof(GSIArray_t));
  GSIArrayInitWithZoneAndCapacity(_cellRects, zone, 8);

  return self;
}

- (void) dealloc
{
  GSIArrayEmpty(_cellRects);
  NSZoneFree(GSObjCZone(self), _cellRects);
  [super dealloc];
}

- (void) setMenu: (NSMenu*)menu
{
  [super setMenu: menu];

  {
    /* regenerate all the necessary cells */
    int i;
    for (i = 0; i < [[[self menu] itemArray] count]; i++)
      {
  	NSDictionary *d = [NSDictionary dictionaryWithObject: [NSNumber numberWithInt: i]
          forKey: @"NSMenuItemIndex"];

        [self itemAdded: [NSNotification
                 notificationWithName: NSMenuDidAddItemNotification
                 object: self
                 userInfo: d]];
      }
  }
}

- (void) itemAdded: (NSNotification*)notification
{
  int         index  = [[[notification userInfo] 
                          objectForKey: @"NSMenuItemIndex"] intValue];
  NSMenuItem *anItem = [[[self menu] itemArray] objectAtIndex: index];
  id          aCell  = [GSHorizontalMenuItemCell new];
  int wasHighlighted = _highlightedItemIndex;

  [aCell setMenuItem: anItem];
  [aCell setMenuView: self];
//  [aCell setFont: _font];

  /* Unlight the previous highlighted cell if the index of the highlighted
   * cell will be ruined up by the insertion of the new cell.  */
  if (wasHighlighted >= index)
    {
      [self setHighlightedItemIndex: -1];
    }
 
  [_itemCells insertObject: aCell atIndex: index];
                          
  /* Restore the highlighted cell, with the new index for it.  */
  if (wasHighlighted >= index)
    {
      /* Please note that if wasHighlighted == -1, it shouldn't be possible
       * to be here.  */
      [self setHighlightedItemIndex: ++wasHighlighted];
    }

  [aCell setNeedsSizing: YES];
  RELEASE(aCell);

  // Mark the menu view as needing to be resized.
  [self setNeedsSizing: YES];
}

- (void) sizeToFit
{
  if (!_horizontal) // if we are not horizontal use the original code
    {
      [super sizeToFit];
      return;
    }
  else 
    {
      unsigned i;
      unsigned howMany = [_itemCells count];
      float currentX = 8;
      NSRect scRect = [[NSScreen mainScreen] frame];

      GSIArrayRemoveAllItems(_cellRects);

      scRect.size.height = [NSMenuView menuBarHeight];
      [self setFrameSize: scRect.size];
      _cellSize.height = scRect.size.height;

      for (i = 0; i < howMany; i++)
	{
      	  GSCellRect elem;
      	  NSMenuItemCell *aCell = [_itemCells objectAtIndex: i];
	  float titleWidth = [aCell titleWidth];

	  if ([aCell imageWidth])
	    {
	      titleWidth += [aCell imageWidth] + xDist;
	    }

	  elem.rect = NSMakeRect (currentX,
			     0,
			     (titleWidth + (2 * _horizontalEdgePad)),
			     _cellSize.height);
  	  GSIArrayAddItem(_cellRects, (GSIArrayItem)elem);

	  currentX += titleWidth + (2 * _horizontalEdgePad);
	}
    }
}

- (NSRect) rectOfItemAtIndex: (int)index
{
  GSCellRect aRect;

  if (_needsSizing == YES)
    {
      [self sizeToFit];
    } 

  aRect = GSIArrayItemAtIndex(_cellRects, index).ext;

  /* FIXME: handle vertical case? */

  return aRect.rect;
}

- (void) drawRect: (NSRect)rect
{
  int        i;
  int        howMany = [_itemCells count];
  NSRectEdge sides[] = {NSMinYEdge, NSMinYEdge};  
  float      grays[] = {NSBlack, NSDarkGray};

  NSDrawTiledRects(_bounds, rect, sides, grays, 2);

  // Draw the menu cells.
  for (i = 0; i < howMany; i++)
    {
      NSRect            aRect;
      NSMenuItemCell    *aCell;
 
      aRect = [self rectOfItemAtIndex: i];
      if (NSIntersectsRect(rect, aRect) == YES)
        {
          aCell = [_itemCells objectAtIndex: i];
          [aCell drawWithFrame: aRect inView: self];
        }
    }
}
@end

@interface NSApplication (Hackery)
@end

@implementation NSApplication (Hackery)
- (void) setApplicationIconImage: (NSImage*)anImage
{
  NSEnumerator  *iterator = [[self windows] objectEnumerator];
  NSWindow      *current;
  NSImage       *old_app_icon = _app_icon;

  RETAIN(old_app_icon);
  [_app_icon setName: nil];
  [anImage setName: @"NSApplicationIcon"];
  ASSIGN(_app_icon, anImage);

  // Update app icon on menubar.
  [_main_menu _organizeMenu];

  if (_app_icon_window != nil)
    {
      [[_app_icon_window contentView] setImage: anImage];
    }

  // Swap the old image for the new one wherever it's used
  while ((current = [iterator nextObject]) != nil)
    {
      if ([current miniwindowImage] == old_app_icon)
        [current setMiniwindowImage: anImage];
    }

  DESTROY(old_app_icon);
}


- (void) setMainMenu: (NSMenu*)aMenu
{
  if (_main_menu != nil && _main_menu != aMenu)
    {
      [_main_menu close];
      [[_main_menu window] setLevel: NSSubmenuWindowLevel];
    }

  ASSIGN(_main_menu, aMenu);

  [_main_menu setMenuRepresentation: [[GSHorizontalMenuView alloc] initWithFrame: NSZeroRect]];
  [[_main_menu menuRepresentation] setHorizontal: YES];
  [_main_menu _organizeMenu];

  // Set the title of the window.
  // This wont be displayed, but the window manager may need it.
  [[_main_menu window] setTitle: [[NSProcessInfo processInfo] processName]];
  [[_main_menu window] setLevel: NSMainMenuWindowLevel];
  [_main_menu setGeometry];
}
@end
