

#include "progress.h"
#include "intern.h"
#include <qapplication.h>
#include <qstring.h>
#include <qprogressdialog.h>

QProgressDialog *progress_dialog=NULL;


Progress::Progress() {
	if (progress_dialog==NULL) progress_dialog=new QProgressDialog();
	progress_dialog->setCancelButtonText( _("Cancel") );
	progress_dialog->setProgress(0);
	//progress_dialog->show();
}

void Progress::show(int step, int total_steps) {
	progress_dialog->setTotalSteps( total_steps );
	progress_dialog->setProgress( step );

	//debug("progress: %d", progress_dialog->progress());

	qApp->processEvents();

	//debug("Progresando: %d de %d", step, total_steps);
}

void Progress::end() {
	progress_dialog->reset();
	qApp->processEvents();
}

void Progress::setLabel( const QString &texto ) {
	progress_dialog->setLabelText( texto );
}

