/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	SixBitCodec_H
#define	SixBitCodec_H

#include <wx/string.h>

const struct {
	wxChar c;
	int    bits;
} charTable[] = {
	{wxT(' '), 0x03}, {wxT('#'), 0x05}, {wxT('$'), 0x06}, {wxT(','), 0x07},
	{wxT('.'), 0x09}, {wxT('/'), 0x0A}, {wxT('?'), 0x0B}, {wxT('0'), 0x0C},
	{wxT('1'), 0x0D}, {wxT('2'), 0x0E}, {wxT('3'), 0x0F}, {wxT('4'), 0x11},
	{wxT('5'), 0x12}, {wxT('6'), 0x13}, {wxT('7'), 0x14}, {wxT('8'), 0x15},
	{wxT('9'), 0x16}, {wxT('A'), 0x17}, {wxT('B'), 0x18}, {wxT('C'), 0x19},
	{wxT('D'), 0x1A}, {wxT('E'), 0x1B}, {wxT('F'), 0x1C}, {wxT('G'), 0x1D},
	{wxT('H'), 0x1E}, {wxT('I'), 0x21}, {wxT('J'), 0x22}, {wxT('K'), 0x23},
	{wxT('L'), 0x24}, {wxT('M'), 0x25}, {wxT('N'), 0x26}, {wxT('O'), 0x27},
	{wxT('P'), 0x28}, {wxT('Q'), 0x29}, {wxT('R'), 0x2A}, {wxT('S'), 0x2B},
	{wxT('T'), 0x2C}, {wxT('U'), 0x2D}, {wxT('V'), 0x2E}, {wxT('W'), 0x2F},
	{wxT('X'), 0x30}, {wxT('Y'), 0x31}, {wxT('Z'), 0x32}, {wxT('a'), 0x17},
	{wxT('b'), 0x18}, {wxT('c'), 0x19}, {wxT('d'), 0x1A}, {wxT('e'), 0x1B},
	{wxT('f'), 0x1C}, {wxT('g'), 0x1D}, {wxT('h'), 0x1E}, {wxT('i'), 0x21},
	{wxT('j'), 0x22}, {wxT('k'), 0x23}, {wxT('l'), 0x24}, {wxT('m'), 0x25},
	{wxT('n'), 0x26}, {wxT('o'), 0x27}, {wxT('p'), 0x28}, {wxT('q'), 0x29},
	{wxT('r'), 0x2A}, {wxT('s'), 0x2B}, {wxT('t'), 0x2C}, {wxT('u'), 0x2D},
	{wxT('v'), 0x2E}, {wxT('w'), 0x2F}, {wxT('x'), 0x30}, {wxT('y'), 0x31},
	{wxT('z'), 0x32}
};

class C6BitCodec {

    public:
	C6BitCodec();
	virtual ~C6BitCodec();

	virtual int    to6Bit(wxChar c) const;
	virtual wxChar toASCII(int bits) const;

    private:
};

#endif
